package net.hserver.apm.plugin.filter;

import ch.qos.logback.classic.spi.LoggingEvent;
import net.hserver.apm.common.DataConfig;
import net.hserver.apm.common.entity.LogInfo;
import top.hserver.core.interfaces.LogAdapter;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.queue.HServerQueue;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.HServerContextHolder;
import top.hserver.core.server.context.HumMessage;
import top.hserver.core.server.context.Webkit;

@Bean
public class ApmLogFilter implements LogAdapter {

    @Override
    public void log(LoggingEvent loggingEvent) throws Exception {

        Webkit webKit = HServerContextHolder.getWebKit();
        if (webKit != null) {
            String requestId = webKit.httpRequest.getRequestId();
            LogInfo logInfo = new LogInfo();
            logInfo.setAppName(ConstConfig.APP_NAME);
            logInfo.setChainId(requestId);
            logInfo.setLevel(loggingEvent.getLevel().levelStr);
            logInfo.setMessage(loggingEvent.getFormattedMessage());
            logInfo.setThreadName(loggingEvent.getThreadName());
            logInfo.setTime(loggingEvent.getTimeStamp());
            StringBuilder stringBuilder = new StringBuilder();
            StackTraceElement[] callerData = loggingEvent.getCallerData();
            for (int i = 0; i < callerData.length; i++) {
                StackTraceElement callerDatum = callerData[i];
                stringBuilder.append(callerDatum.toString());
                if (i < callerData.length - 1) {
                    stringBuilder.append("->");
                }
            }
            logInfo.setStackTrace(stringBuilder.toString());
            HServerQueue.sendQueue("APM_SEND", DataConfig.APM_DATA_LOG_INFO, logInfo);
        }

    }
}
