/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.concurrentunit;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.jodah.concurrentunit.internal.ReentrantCircuit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class Waiter {
    private static final String TIMEOUT_MESSAGE = "Test timed out while waiting for an expected result, expectedResumes: %d, actualResumes: %d";
    private AtomicInteger remainingResumes = new AtomicInteger(0);
    private final ReentrantCircuit circuit = new ReentrantCircuit();
    private volatile Throwable failure;

    public Waiter() {
        this.circuit.open();
    }

    public void assertEquals(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        this.fail(this.format(expected, actual));
    }

    public void assertFalse(boolean condition) {
        if (condition) {
            this.fail("expected false");
        }
    }

    public void assertNotNull(Object object) {
        if (object == null) {
            this.fail("expected not null");
        }
    }

    public void assertNull(Object object) {
        if (object != null) {
            this.fail(this.format("null", object));
        }
    }

    public void assertTrue(boolean condition) {
        if (!condition) {
            this.fail("expected true");
        }
    }

    public <T> void assertThat(T actual, Matcher<? super T> matcher) {
        try {
            MatcherAssert.assertThat(actual, matcher);
        }
        catch (AssertionError e) {
            this.fail((Throwable)((Object)e));
        }
    }

    public void await() throws TimeoutException, InterruptedException {
        this.await(0L, TimeUnit.MILLISECONDS, 1);
    }

    public void await(long delay) throws TimeoutException, InterruptedException {
        this.await(delay, TimeUnit.MILLISECONDS, 1);
    }

    public void await(long delay, TimeUnit timeUnit) throws TimeoutException, InterruptedException {
        this.await(delay, timeUnit, 1);
    }

    public void await(long delay, int expectedResumes) throws TimeoutException, InterruptedException {
        this.await(delay, TimeUnit.MILLISECONDS, expectedResumes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long delay, TimeUnit timeUnit, int expectedResumes) throws TimeoutException, InterruptedException {
        block11: {
            try {
                if (this.failure != null) break block11;
                Waiter waiter = this;
                synchronized (waiter) {
                    int remaining = this.remainingResumes.addAndGet(expectedResumes);
                    if (remaining > 0) {
                        this.circuit.open();
                    }
                }
                if (delay == 0L) {
                    this.circuit.await();
                } else if (!this.circuit.await(delay, timeUnit)) {
                    int actualResumes = expectedResumes - this.remainingResumes.get();
                    throw new TimeoutException(String.format(TIMEOUT_MESSAGE, expectedResumes, actualResumes));
                }
            }
            finally {
                this.remainingResumes.set(0);
                this.circuit.open();
                if (this.failure != null) {
                    Throwable f = this.failure;
                    this.failure = null;
                    Waiter.sneakyThrow(f);
                }
            }
        }
    }

    public synchronized void resume() {
        if (this.remainingResumes.decrementAndGet() <= 0) {
            this.circuit.close();
        }
    }

    public void fail() {
        this.fail((Throwable)((Object)new AssertionError()));
    }

    public void fail(String reason) {
        this.fail((Throwable)((Object)new AssertionError((Object)reason)));
    }

    public void fail(Throwable reason) {
        AssertionError ae = null;
        if (reason instanceof AssertionError) {
            ae = (AssertionError)((Object)reason);
        } else {
            ae = new AssertionError();
            ((Throwable)((Object)ae)).initCause(reason);
        }
        this.failure = ae;
        this.circuit.close();
        throw ae;
    }

    public void rethrow(Throwable failure) {
        this.failure = failure;
        this.circuit.close();
        Waiter.sneakyThrow(failure);
    }

    private static void sneakyThrow(Throwable t) {
        Waiter.sneakyThrow2(t);
    }

    private static <T extends Throwable> void sneakyThrow2(Throwable t) throws T {
        throw t;
    }

    private String format(Object expected, Object actual) {
        return "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

