/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.api.arbitraries.SizableArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.api.arbitraries.TypeArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequenceArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public class Arbitraries {
    private Arbitraries() {
    }

    public static <T> Arbitrary<T> fromGenerator(RandomGenerator<T> generator) {
        return tries -> generator;
    }

    public static <T> Arbitrary<T> randomValue(Function<Random, T> generator) {
        return Arbitraries.fromGenerator(random -> Shrinkable.unshrinkable(generator.apply(random)));
    }

    public static Arbitrary<Random> randoms() {
        return Arbitraries.randomValue(random -> new Random(random.nextLong()));
    }

    @SafeVarargs
    public static <T> Arbitrary<T> of(T ... values) {
        return Arbitraries.of(Arrays.asList(values));
    }

    public static <T> Arbitrary<T> of(List<T> values) {
        return Arbitraries.fromGenerators(ArbitrariesFacade.implementation.randomChoose(values), max -> ArbitrariesFacade.implementation.exhaustiveChoose(values, (long)max));
    }

    public static Arbitrary<Character> of(char[] values) {
        return Arbitraries.fromGenerators(ArbitrariesFacade.implementation.randomChoose(values), max -> ArbitrariesFacade.implementation.exhaustiveChoose(values, (long)max));
    }

    public static <T extends Enum> Arbitrary<T> of(Class<T> enumClass) {
        return Arbitraries.fromGenerators(ArbitrariesFacade.implementation.randomChoose(enumClass), max -> ArbitrariesFacade.implementation.exhaustiveChoose(enumClass, (long)max));
    }

    @SafeVarargs
    public static <T> Arbitrary<T> oneOf(Arbitrary<? extends T> first, Arbitrary<? extends T> ... rest) {
        ArrayList<Arbitrary<T>> all = new ArrayList<Arbitrary<T>>();
        all.add(first);
        for (Arbitrary<? extends T> arbitrary : rest) {
            all.add(arbitrary);
        }
        return Arbitraries.oneOf(all);
    }

    public static <T> Arbitrary<T> oneOf(List<Arbitrary<T>> all) {
        if (all.size() == 1) {
            return all.get(0);
        }
        return ArbitrariesFacade.implementation.oneOf(all);
    }

    @SafeVarargs
    public static <T> Arbitrary<T> frequency(Tuple.Tuple2<Integer, T> ... frequencies) {
        return Arbitraries.frequency(Arrays.asList(frequencies));
    }

    public static <T> Arbitrary<T> frequency(List<Tuple.Tuple2<Integer, T>> frequencies) {
        List values = frequencies.stream().filter(f -> (Integer)f.get1() > 0).map(Tuple.Tuple2::get2).collect(Collectors.toList());
        return Arbitraries.fromGenerators(ArbitrariesFacade.implementation.randomFrequency(frequencies), max -> ArbitrariesFacade.implementation.exhaustiveChoose(values, (long)max));
    }

    @SafeVarargs
    public static <T> Arbitrary<T> frequencyOf(Tuple.Tuple2<Integer, Arbitrary<T>> ... frequencies) {
        return Arbitraries.frequencyOf(Arrays.asList(frequencies));
    }

    public static <T> Arbitrary<T> frequencyOf(List<Tuple.Tuple2<Integer, Arbitrary<T>>> frequencies) {
        return ArbitrariesFacade.implementation.frequencyOf(frequencies);
    }

    public static IntegerArbitrary integers() {
        return ArbitrariesFacade.implementation.integers();
    }

    public static LongArbitrary longs() {
        return ArbitrariesFacade.implementation.longs();
    }

    public static BigIntegerArbitrary bigIntegers() {
        return ArbitrariesFacade.implementation.bigIntegers();
    }

    public static FloatArbitrary floats() {
        return ArbitrariesFacade.implementation.floats();
    }

    public static BigDecimalArbitrary bigDecimals() {
        return ArbitrariesFacade.implementation.bigDecimals();
    }

    public static DoubleArbitrary doubles() {
        return ArbitrariesFacade.implementation.doubles();
    }

    public static ByteArbitrary bytes() {
        return ArbitrariesFacade.implementation.bytes();
    }

    public static ShortArbitrary shorts() {
        return ArbitrariesFacade.implementation.shorts();
    }

    public static StringArbitrary strings() {
        return ArbitrariesFacade.implementation.strings();
    }

    public static CharacterArbitrary chars() {
        return ArbitrariesFacade.implementation.chars();
    }

    @SafeVarargs
    public static <T> Arbitrary<T> samples(T ... samples) {
        return Arbitraries.fromGenerators(ArbitrariesFacade.implementation.randomSamples(samples), max -> ArbitrariesFacade.implementation.exhaustiveChoose(Arrays.asList(samples), (long)max));
    }

    public static <T> Arbitrary<T> constant(T value) {
        return Arbitraries.fromGenerators(random -> Shrinkable.unshrinkable(value), max -> ArbitrariesFacade.implementation.exhaustiveChoose(Arrays.asList(value), (long)max));
    }

    @API(status=API.Status.MAINTAINED, since="1.1.1")
    public static <T> Arbitrary<T> create(Supplier<T> supplier) {
        return Arbitraries.fromGenerators(random -> Shrinkable.unshrinkable(supplier.get()), max -> ArbitrariesFacade.implementation.exhaustiveCreate(supplier, (long)max));
    }

    @SafeVarargs
    public static <T> Arbitrary<List<T>> shuffle(T ... values) {
        return Arbitraries.shuffle(Arrays.asList(values));
    }

    public static <T> Arbitrary<List<T>> shuffle(List<T> values) {
        return Arbitraries.fromGenerators(ArbitrariesFacade.implementation.randomShuffle(values), max -> ArbitrariesFacade.implementation.exhaustiveShuffle(values, (long)max));
    }

    public static <T> Arbitrary<T> defaultFor(Class<T> type, Class<?> ... typeParameters) {
        return ArbitrariesFacade.implementation.defaultFor(type, typeParameters);
    }

    @API(status=API.Status.MAINTAINED, since="1.1")
    public static <T> Arbitrary<T> defaultFor(TypeUsage typeUsage) {
        return ArbitrariesFacade.implementation.defaultFor(typeUsage);
    }

    @API(status=API.Status.MAINTAINED, since="1.2.0")
    public static <T> TypeArbitrary<T> forType(Class<T> targetType) {
        return ArbitrariesFacade.implementation.forType(targetType);
    }

    private static <T> Arbitrary<T> fromGenerators(final RandomGenerator<T> randomGenerator, final Function<Long, Optional<ExhaustiveGenerator<T>>> exhaustiveGeneratorFunction) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int tries) {
                return randomGenerator;
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return (Optional)exhaustiveGeneratorFunction.apply(maxNumberOfSamples);
            }
        };
    }

    public static <T> Arbitrary<T> lazy(Supplier<Arbitrary<T>> arbitrarySupplier) {
        return ArbitrariesFacade.implementation.lazy(arbitrarySupplier);
    }

    public static <T> Arbitrary<T> recursive(Supplier<Arbitrary<T>> base, Function<Arbitrary<T>, Arbitrary<T>> recur, int depth) {
        if (depth == 0) {
            return base.get();
        }
        return recur.apply(Arbitraries.recursive(base, recur, depth - 1));
    }

    @API(status=API.Status.MAINTAINED, since="1.0")
    public static <M> ActionSequenceArbitrary<M> sequences(Arbitrary<? extends Action<M>> actionArbitrary) {
        return ArbitrariesFacade.implementation.sequences(actionArbitrary);
    }

    @API(status=API.Status.MAINTAINED, since="1.1.6")
    public static <K, V> SizableArbitrary<Map<K, V>> maps(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        return ArbitrariesFacade.implementation.maps(keysArbitrary, valuesArbitrary);
    }

    @API(status=API.Status.MAINTAINED, since="1.2.0")
    public static <K, V> Arbitrary<Map.Entry<K, V>> entries(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        return ArbitrariesFacade.implementation.entries(keysArbitrary, valuesArbitrary);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.1.6")
    public static Arbitrary<Void> nothing() {
        return Arbitraries.constant(null);
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ArbitrariesFacade {
        private static ArbitrariesFacade implementation = FacadeLoader.load(ArbitrariesFacade.class);

        public abstract <T> Optional<ExhaustiveGenerator<T>> exhaustiveChoose(List<T> var1, long var2);

        public abstract <T> Optional<ExhaustiveGenerator<T>> exhaustiveCreate(Supplier<T> var1, long var2);

        public abstract Optional<ExhaustiveGenerator<Character>> exhaustiveChoose(char[] var1, long var2);

        public abstract <T> Optional<ExhaustiveGenerator<List<T>>> exhaustiveShuffle(List<T> var1, long var2);

        public abstract <T extends Enum> Optional<ExhaustiveGenerator<T>> exhaustiveChoose(Class<T> var1, long var2);

        public abstract <T> RandomGenerator<T> randomChoose(List<T> var1);

        public abstract RandomGenerator<Character> randomChoose(char[] var1);

        public abstract <T extends Enum> RandomGenerator<T> randomChoose(Class<T> var1);

        public abstract <T> Arbitrary<T> oneOf(List<Arbitrary<T>> var1);

        public abstract <T> RandomGenerator<T> randomFrequency(List<Tuple.Tuple2<Integer, T>> var1);

        public abstract <T> RandomGenerator<T> randomSamples(T[] var1);

        public abstract <T> RandomGenerator<List<T>> randomShuffle(List<T> var1);

        public abstract <M> ActionSequenceArbitrary<M> sequences(Arbitrary<? extends Action<M>> var1);

        public abstract <T> Arbitrary<T> frequencyOf(List<Tuple.Tuple2<Integer, Arbitrary<T>>> var1);

        public abstract IntegerArbitrary integers();

        public abstract LongArbitrary longs();

        public abstract BigIntegerArbitrary bigIntegers();

        public abstract FloatArbitrary floats();

        public abstract BigDecimalArbitrary bigDecimals();

        public abstract DoubleArbitrary doubles();

        public abstract ByteArbitrary bytes();

        public abstract ShortArbitrary shorts();

        public abstract StringArbitrary strings();

        public abstract CharacterArbitrary chars();

        public abstract <T> Arbitrary<T> defaultFor(Class<T> var1, Class<?>[] var2);

        public abstract <T> Arbitrary<T> defaultFor(TypeUsage var1);

        public abstract <T> Arbitrary<T> lazy(Supplier<Arbitrary<T>> var1);

        public abstract <T> TypeArbitrary<T> forType(Class<T> var1);

        public abstract <K, V> SizableArbitrary<Map<K, V>> maps(Arbitrary<K> var1, Arbitrary<V> var2);

        public abstract <K, V> Arbitrary<Map.Entry<K, V>> entries(Arbitrary<K> var1, Arbitrary<V> var2);
    }
}

