/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.StreamableArbitrary;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public interface Arbitrary<T> {
    @API(status=API.Status.INTERNAL, since="1.2.4")
    default public Arbitrary<Object> asGeneric() {
        return this;
    }

    public RandomGenerator<T> generator(int var1);

    default public Optional<ExhaustiveGenerator<T>> exhaustive() {
        return this.exhaustive(Integer.MAX_VALUE);
    }

    @API(status=API.Status.MAINTAINED, since="1.2.1")
    default public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        return Optional.empty();
    }

    default public Optional<Stream<T>> allValues() {
        return this.exhaustive().map((? super T generator) -> StreamSupport.stream(generator.spliterator(), false));
    }

    @API(status=API.Status.MAINTAINED, since="1.1.2")
    default public void forEachValue(Consumer<? super T> action) {
        if (!this.allValues().isPresent()) {
            throw new AssertionError((Object)("Cannot generate all values of " + this.toString()));
        }
        this.allValues().ifPresent(stream -> stream.forEach(action::accept));
    }

    default public Arbitrary<T> filter(final Predicate<T> filterPredicate) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).filter(filterPredicate);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples).map((? super T generator) -> generator.filter(filterPredicate));
            }
        };
    }

    default public <U> Arbitrary<U> map(final Function<T, U> mapper) {
        return new Arbitrary<U>(){

            @Override
            public RandomGenerator<U> generator(int genSize) {
                return Arbitrary.this.generator(genSize).map(mapper);
            }

            @Override
            public Optional<ExhaustiveGenerator<U>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples).map((? super T generator) -> generator.map(mapper));
            }
        };
    }

    default public <U> Arbitrary<U> flatMap(final Function<T, Arbitrary<U>> mapper) {
        return new Arbitrary<U>(){

            @Override
            public RandomGenerator<U> generator(int genSize) {
                return Arbitrary.this.generator(genSize).flatMap(mapper, genSize);
            }

            @Override
            public Optional<ExhaustiveGenerator<U>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples).flatMap((? super T generator) -> ArbitraryFacade.implementation.flatMapExhaustiveGenerator(generator, mapper, maxNumberOfSamples));
            }
        };
    }

    default public Arbitrary<T> injectNull(final double nullProbability) {
        if (nullProbability <= 0.0) {
            return this;
        }
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).injectNull(nullProbability);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples).map((? super T ts) -> ts.injectNull());
            }
        };
    }

    default public Arbitrary<T> unique() {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).unique();
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples).map(ExhaustiveGenerator::unique);
            }

            @Override
            public StreamableArbitrary<T, List<T>> list() {
                return ArbitraryFacade.implementation.listOfUnique(this);
            }

            @Override
            public <A> StreamableArbitrary<T, A> array(Class<A> arrayClass) {
                return ArbitraryFacade.implementation.arrayOfUnique(this, arrayClass);
            }
        };
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.2.2")
    default public Arbitrary<T> withSamples(final T ... samples) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).withSamples(samples);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples).map((? super T exhaustive) -> exhaustive.withSamples(samples));
            }
        };
    }

    @API(status=API.Status.MAINTAINED, since="1.2.0")
    default public Arbitrary<T> fixGenSize(final int genSize) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int ignoredGenSize) {
                return Arbitrary.this.generator(genSize);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples);
            }
        };
    }

    default public StreamableArbitrary<T, List<T>> list() {
        return ArbitraryFacade.implementation.list(this);
    }

    default public StreamableArbitrary<T, Set<T>> set() {
        return ArbitraryFacade.implementation.set(this);
    }

    default public StreamableArbitrary<T, Stream<T>> stream() {
        return ArbitraryFacade.implementation.stream(this);
    }

    default public StreamableArbitrary<T, Iterator<T>> iterator() {
        return ArbitraryFacade.implementation.iterator(this);
    }

    default public <A> StreamableArbitrary<T, A> array(Class<A> arrayClass) {
        return ArbitraryFacade.implementation.array(this, arrayClass);
    }

    default public Arbitrary<Optional<T>> optional() {
        return this.injectNull(0.05).map(Optional::ofNullable);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.1.4")
    default public Arbitrary<List<T>> collect(Predicate<List<T>> until) {
        return genSize -> this.generator(genSize).collect(until);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.2")
    default public Stream<T> sampleStream() {
        return ArbitraryFacade.implementation.sampleStream(this);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.2")
    default public T sample() {
        return this.sampleStream().findFirst().orElseThrow(() -> new JqwikException("Cannot generate a value"));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.3")
    default public Arbitrary<T> injectDuplicates(final double duplicateProbability) {
        return new Arbitrary<T>(){

            @Override
            public RandomGenerator<T> generator(int genSize) {
                return Arbitrary.this.generator(genSize).injectDuplicates(duplicateProbability);
            }

            @Override
            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return Arbitrary.this.exhaustive(maxNumberOfSamples);
            }
        };
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.3")
    default public Arbitrary<Tuple.Tuple1<T>> tuple1() {
        return this.map(Tuple::of);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.3")
    default public Arbitrary<Tuple.Tuple2<T, T>> tuple2() {
        return this.list().ofSize(2).map(l -> Tuple.of(l.get(0), l.get(1)));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.3")
    default public Arbitrary<Tuple.Tuple3<T, T, T>> tuple3() {
        return this.list().ofSize(3).map(l -> Tuple.of(l.get(0), l.get(1), l.get(2)));
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.2.3")
    default public Arbitrary<Tuple.Tuple4<T, T, T, T>> tuple4() {
        return this.list().ofSize(4).map(l -> Tuple.of(l.get(0), l.get(1), l.get(2), l.get(3)));
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ArbitraryFacade {
        private static ArbitraryFacade implementation = FacadeLoader.load(ArbitraryFacade.class);

        public abstract <T, U> Optional<ExhaustiveGenerator<U>> flatMapExhaustiveGenerator(ExhaustiveGenerator<T> var1, Function<T, Arbitrary<U>> var2, long var3);

        public abstract <T> StreamableArbitrary<T, List<T>> list(Arbitrary<T> var1);

        public abstract <T> StreamableArbitrary<T, List<T>> listOfUnique(Arbitrary<T> var1);

        public abstract <T> StreamableArbitrary<T, Set<T>> set(Arbitrary<T> var1);

        public abstract <T> StreamableArbitrary<T, Stream<T>> stream(Arbitrary<T> var1);

        public abstract <T> StreamableArbitrary<T, Iterator<T>> iterator(Arbitrary<T> var1);

        public abstract <T, A> StreamableArbitrary<T, A> array(Arbitrary<T> var1, Class<A> var2);

        public abstract <T, A> StreamableArbitrary<T, A> arrayOfUnique(Arbitrary<T> var1, Class<A> var2);

        public abstract <T> Stream<T> sampleStream(Arbitrary<T> var1);
    }
}

