/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryExecutor;
import net.jqwik.engine.descriptor.PropertyConfiguration;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.CachingArbitraryResolver;
import net.jqwik.engine.execution.CheckedProperty;
import net.jqwik.engine.execution.lifecycle.AroundTryLifecycle;
import net.jqwik.engine.execution.lifecycle.StoreRepository;
import net.jqwik.engine.execution.lifecycle.TryLifecycleExecutor;
import net.jqwik.engine.facades.DomainContextFacadeImpl;
import net.jqwik.engine.properties.CheckedFunction;
import net.jqwik.engine.properties.PropertyMethodArbitraryResolver;
import net.jqwik.engine.properties.PropertyMethodDataResolver;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.MethodParameter;
import org.junit.platform.commons.support.ReflectionSupport;

public class CheckedPropertyFactory {
    private static List<Class<?>> BOOLEAN_RETURN_TYPES = Arrays.asList(Boolean.TYPE, Boolean.class);

    public CheckedProperty fromDescriptor(PropertyMethodDescriptor propertyMethodDescriptor, PropertyLifecycleContext propertyLifecycleContext, AroundTryHook aroundTry, ResolveParameterHook parameterResolver) {
        String propertyName = propertyMethodDescriptor.extendedLabel();
        Method propertyMethod = propertyMethodDescriptor.getTargetMethod();
        PropertyConfiguration configuration = propertyMethodDescriptor.getConfiguration();
        TryLifecycleExecutor tryLifecycleExecutor = this.createTryExecutor(propertyMethodDescriptor, propertyLifecycleContext, aroundTry);
        List<MethodParameter> propertyParameters = this.extractParameters(propertyMethod, propertyMethodDescriptor.getContainerClass());
        PropertyMethodArbitraryResolver arbitraryResolver = new PropertyMethodArbitraryResolver(propertyMethodDescriptor.getContainerClass(), propertyLifecycleContext.testInstance(), DomainContextFacadeImpl.getCurrentContext());
        Optional<Iterable<? extends Tuple>> optionalData = new PropertyMethodDataResolver(propertyMethodDescriptor.getContainerClass(), propertyLifecycleContext.testInstance()).forMethod(propertyMethodDescriptor.getTargetMethod());
        return new CheckedProperty(propertyName, tryLifecycleExecutor, propertyParameters, new CachingArbitraryResolver(arbitraryResolver), parameterResolver, propertyLifecycleContext, optionalData, configuration);
    }

    private TryLifecycleExecutor createTryExecutor(PropertyMethodDescriptor propertyMethodDescriptor, PropertyLifecycleContext propertyLifecycleContext, AroundTryHook aroundTry) {
        AroundTryHook aroundTryWithFinishing = (context, aTry, parameters) -> {
            try {
                TryExecutionResult tryExecutionResult = aroundTry.aroundTry(context, aTry, parameters);
                return tryExecutionResult;
            }
            finally {
                StoreRepository.getCurrent().finishTry(propertyMethodDescriptor);
            }
        };
        TryExecutor rawExecutor = this.createRawExecutor(propertyMethodDescriptor, propertyLifecycleContext.testInstance());
        return new AroundTryLifecycle(rawExecutor, aroundTryWithFinishing);
    }

    private TryExecutor createRawExecutor(PropertyMethodDescriptor propertyMethodDescriptor, Object testInstance) {
        return this.createRawFunction(propertyMethodDescriptor, testInstance);
    }

    private CheckedFunction createRawFunction(PropertyMethodDescriptor propertyMethodDescriptor, Object testInstance) {
        Method targetMethod = propertyMethodDescriptor.getTargetMethod();
        Class<?> returnType = targetMethod.getReturnType();
        Function<List, Object> function = params -> ReflectionSupport.invokeMethod((Method)targetMethod, (Object)testInstance, (Object[])params.toArray());
        if (BOOLEAN_RETURN_TYPES.contains(returnType)) {
            return params -> (Boolean)function.apply((List)params);
        }
        return params -> {
            function.apply((List)params);
            return true;
        };
    }

    private List<MethodParameter> extractParameters(Method targetMethod, Class<?> containerClass) {
        return JqwikReflectionSupport.getMethodParameters(targetMethod, containerClass);
    }
}

