/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.jqwik.api.JqwikException;
import org.junit.platform.engine.TestDescriptor;

public class CurrentTestDescriptor {
    private static ThreadLocal<List<TestDescriptor>> descriptors = ThreadLocal.withInitial(ArrayList::new);

    public static void runWithDescriptor(TestDescriptor currentDescriptor, Runnable executable) {
        Supplier<Void> supplier = () -> {
            executable.run();
            return null;
        };
        CurrentTestDescriptor.runWithDescriptor(currentDescriptor, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithDescriptor(TestDescriptor currentDescriptor, Supplier<T> executable) {
        descriptors.get().add(0, currentDescriptor);
        try {
            T t = executable.get();
            return t;
        }
        finally {
            TestDescriptor peek = descriptors.get().get(0);
            if (peek == currentDescriptor) {
                descriptors.get().remove(0);
            }
        }
    }

    public static TestDescriptor get() {
        if (descriptors.get().isEmpty()) {
            String message = String.format("The current action must be run on a jqwik thread, i.e. container, property or hook.%nMaybe you spawned off a thread?", new Object[0]);
            throw new JqwikException(message);
        }
        return descriptors.get().get(0);
    }
}

