/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.engine.execution.lifecycle.ScopedStore;
import org.junit.platform.engine.TestDescriptor;

public class StoreRepository {
    private static StoreRepository current;
    private Set<ScopedStore<?>> stores = new HashSet();

    public static synchronized StoreRepository getCurrent() {
        if (current == null) {
            current = new StoreRepository();
        }
        return current;
    }

    public <T> ScopedStore<T> create(TestDescriptor scope, Object identifier, Lifespan lifespan, Supplier<T> initializer) {
        if (scope == null) {
            throw new IllegalArgumentException("scope must not be null");
        }
        if (initializer == null) {
            throw new IllegalArgumentException("initializer must not be null");
        }
        if (lifespan == null) {
            throw new IllegalArgumentException("lifespan must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        ScopedStore<T> store = new ScopedStore<T>(identifier, lifespan, scope, initializer);
        this.addStore(identifier, store);
        return store;
    }

    private <T> void addStore(Object identifier, ScopedStore<T> newStore) {
        Optional<ScopedStore> conflictingStore = this.stores.stream().filter(store -> store.getIdentifier().equals(newStore.getIdentifier())).filter(store -> this.isVisibleInAncestorOrDescendant(newStore, (ScopedStore<?>)store)).findFirst();
        conflictingStore.ifPresent(existingStore -> {
            String message = String.format("You cannot create %s with identifier [%s]. It conflicts with existing %s", newStore, identifier.toString(), conflictingStore);
            throw new JqwikException(message);
        });
        this.stores.add(newStore);
    }

    private <T> boolean isVisibleInAncestorOrDescendant(ScopedStore<T> newStore, ScopedStore<?> store) {
        return store.isVisibleFor(newStore.getScope()) || newStore.isVisibleFor(store.getScope());
    }

    public <T> Optional<ScopedStore<T>> get(TestDescriptor retriever, Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        return this.stores.stream().filter(store -> store.getIdentifier().equals(identifier)).filter(store -> store.isVisibleFor(retriever)).map(store -> store).findFirst();
    }

    public void finishScope(TestDescriptor scope) {
        List storesToRemove = this.stores.stream().filter(store -> this.isStoreIn((ScopedStore<?>)store, scope)).collect(Collectors.toList());
        for (ScopedStore store2 : storesToRemove) {
            store2.close();
            this.stores.remove(store2);
        }
    }

    private boolean isStoreIn(ScopedStore<?> store, TestDescriptor scope) {
        return store.getScope().equals(scope) || scope.getDescendants().contains(store.getScope());
    }

    public void finishProperty(TestDescriptor scope) {
        this.stores.stream().filter(store -> store.lifespan() == Lifespan.PROPERTY).filter(store -> store.isVisibleFor(scope)).forEach(ScopedStore::reset);
    }

    public void finishTry(TestDescriptor scope) {
        this.stores.stream().filter(store -> store.lifespan() == Lifespan.TRY).filter(store -> store.isVisibleFor(scope)).forEach(ScopedStore::reset);
    }
}

