/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.List;
import java.util.Optional;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.engine.execution.lifecycle.ExtendedPropertyExecutionResult;
import net.jqwik.engine.execution.lifecycle.PlainExecutionResult;
import net.jqwik.engine.support.JqwikStringSupport;
import org.opentest4j.AssertionFailedError;

public class PropertyCheckResult
implements ExtendedPropertyExecutionResult {
    private final String stereotype;
    private final CheckStatus status;
    private final String propertyName;
    private final int tries;
    private final int checks;
    private final String randomSeed;
    private final GenerationMode generation;
    private final List<Object> sample;
    private final List<Object> originalSample;
    private final Throwable throwable;

    public static PropertyCheckResult successful(String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation) {
        return new PropertyCheckResult(CheckStatus.SUCCESSFUL, stereotype, propertyName, tries, checks, randomSeed, generation, null, null, null);
    }

    public static PropertyCheckResult failed(String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation, List<Object> sample, List<Object> originalSample, Throwable throwable) {
        return new PropertyCheckResult(CheckStatus.FAILED, stereotype, propertyName, tries, checks, randomSeed, generation, sample, originalSample, throwable);
    }

    public static PropertyCheckResult exhausted(String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation) {
        return new PropertyCheckResult(CheckStatus.EXHAUSTED, stereotype, propertyName, tries, checks, randomSeed, generation, null, null, null);
    }

    private PropertyCheckResult(CheckStatus status, String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation, List<Object> sample, List<Object> originalSample, Throwable throwable) {
        this.stereotype = stereotype;
        this.status = status;
        this.propertyName = propertyName;
        this.tries = tries;
        this.checks = checks;
        this.randomSeed = randomSeed;
        this.generation = generation;
        this.sample = sample;
        this.originalSample = originalSample;
        this.throwable = this.determineThrowable(status, throwable);
    }

    private Throwable determineThrowable(CheckStatus status, Throwable throwable) {
        if (status != CheckStatus.FAILED) {
            return null;
        }
        if (throwable == null) {
            return new AssertionFailedError(this.toString());
        }
        return throwable;
    }

    public Optional<List<Object>> falsifiedSample() {
        return Optional.ofNullable(this.sample);
    }

    public Optional<String> seed() {
        return Optional.ofNullable(this.randomSeed());
    }

    public PropertyExecutionResult.Status status() {
        return this.checkStatus() == CheckStatus.SUCCESSFUL ? PropertyExecutionResult.Status.SUCCESSFUL : PropertyExecutionResult.Status.FAILED;
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    public PropertyExecutionResult mapTo(PropertyExecutionResult.Status newStatus, Throwable throwable) {
        switch (newStatus) {
            case ABORTED: {
                return PlainExecutionResult.aborted(throwable, this.randomSeed);
            }
            case FAILED: {
                return new PropertyCheckResult(CheckStatus.FAILED, this.stereotype, this.propertyName, this.tries, this.checks, this.randomSeed, this.generation, this.sample, this.originalSample, throwable);
            }
            case SUCCESSFUL: {
                return new PropertyCheckResult(CheckStatus.SUCCESSFUL, this.stereotype, this.propertyName, this.tries, this.checks, this.randomSeed, this.generation, this.sample, this.originalSample, throwable);
            }
        }
        throw new IllegalStateException(String.format("Unknown state: %s", newStatus.name()));
    }

    @Override
    public boolean isExtended() {
        return true;
    }

    public String propertyName() {
        return this.propertyName;
    }

    public CheckStatus checkStatus() {
        return this.status;
    }

    public int countChecks() {
        return this.checks;
    }

    public int countTries() {
        return this.tries;
    }

    @Override
    public String randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Optional<List<Object>> originalSample() {
        return Optional.ofNullable(this.originalSample);
    }

    @Override
    public GenerationMode generation() {
        return this.generation;
    }

    public String toString() {
        String header = String.format("%s [%s] failed", this.stereotype, this.propertyName);
        switch (this.checkStatus()) {
            case FAILED: {
                String sampleString = this.sample.isEmpty() ? "" : String.format(" with sample %s", JqwikStringSupport.displayString(this.sample));
                return String.format("%s%s", header, sampleString);
            }
            case EXHAUSTED: {
                int rejections = this.tries - this.checks;
                return String.format("%s after [%d] tries and [%d] rejections", header, this.tries, rejections);
            }
        }
        return header;
    }

    static enum CheckStatus {
        SUCCESSFUL,
        FAILED,
        EXHAUSTED;

    }
}

