/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.List;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.DefaultArbitraries;

public class RegisteredArbitraryConfigurer {
    private final List<ArbitraryConfigurator> registeredConfigurators = new ArrayList<ArbitraryConfigurator>();

    public RegisteredArbitraryConfigurer(List<ArbitraryConfigurator> registeredConfigurators) {
        this.registeredConfigurators.addAll(registeredConfigurators);
        this.registeredConfigurators.addAll(DefaultArbitraries.getDefaultConfigurators());
    }

    public Arbitrary<?> configure(Arbitrary<?> createdArbitrary, TypeUsage targetType) {
        if (this.hasConfigurationAnnotation(targetType)) {
            for (ArbitraryConfigurator arbitraryConfigurator : this.registeredConfigurators) {
                if (createdArbitrary == null) break;
                if (createdArbitrary instanceof SelfConfiguringArbitrary) {
                    createdArbitrary = this.performSelfConfiguration(createdArbitrary, arbitraryConfigurator, targetType);
                    continue;
                }
                createdArbitrary = arbitraryConfigurator.configure(createdArbitrary, targetType);
            }
        }
        return createdArbitrary;
    }

    private boolean hasConfigurationAnnotation(TypeUsage targetType) {
        return targetType.getAnnotations().stream().anyMatch(annotation -> !annotation.annotationType().equals(ForAll.class));
    }

    private <T> Arbitrary<T> performSelfConfiguration(Arbitrary<T> arbitrary, ArbitraryConfigurator configurator, TypeUsage parameter) {
        SelfConfiguringArbitrary selfConfiguringArbitrary = (SelfConfiguringArbitrary)arbitrary;
        return selfConfiguringArbitrary.configure(configurator, parameter);
    }
}

