/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.exhaustive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.CombinedExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.FlatMappedExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.IterableBasedExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.ListExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.PermutationExhaustiveGenerator;
import net.jqwik.engine.properties.arbitraries.exhaustive.SetExhaustiveGenerator;

public class ExhaustiveGenerators {
    public static <T> Optional<ExhaustiveGenerator<T>> create(Supplier<T> supplier, long maxNumberOfSamples) {
        return ExhaustiveGenerators.fromIterable(() -> new SupplierIterator(supplier), 1L, maxNumberOfSamples);
    }

    public static <T> Optional<ExhaustiveGenerator<T>> choose(List<T> values, long maxNumberOfSamples) {
        return ExhaustiveGenerators.fromIterable(values, values.size(), maxNumberOfSamples);
    }

    public static Optional<ExhaustiveGenerator<Character>> choose(char[] characters, long maxNumberOfSamples) {
        ArrayList<Character> validCharacters = new ArrayList<Character>(characters.length);
        for (char character : characters) {
            validCharacters.add(Character.valueOf(character));
        }
        return ExhaustiveGenerators.choose(validCharacters, maxNumberOfSamples);
    }

    public static <T extends Enum<T>> Optional<ExhaustiveGenerator<T>> choose(Class<T> enumClass, long maxNumberOfSamples) {
        return ExhaustiveGenerators.choose(Arrays.asList(enumClass.getEnumConstants()), maxNumberOfSamples);
    }

    public static <T> Optional<ExhaustiveGenerator<T>> fromIterable(Iterable<T> iterator, long maxCount, long maxNumberOfSamples) {
        if (maxCount > maxNumberOfSamples) {
            return Optional.empty();
        }
        return Optional.of(new IterableBasedExhaustiveGenerator<T>(iterator, maxCount));
    }

    public static <T> Optional<ExhaustiveGenerator<List<T>>> list(Arbitrary<T> elementArbitrary, int minSize, int maxSize, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = ListExhaustiveGenerator.calculateMaxCount(elementArbitrary, minSize, maxSize, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> {
            ListExhaustiveGenerator exhaustiveGenerator = new ListExhaustiveGenerator(elementArbitrary, (Long)maxCount, minSize, maxSize);
            Optional exhaustive = elementArbitrary.exhaustive(maxNumberOfSamples);
            if (exhaustive.isPresent() && ((ExhaustiveGenerator)exhaustive.get()).isUnique()) {
                Predicate<List> allElementsUnique = list -> list.size() == new HashSet(list).size();
                return exhaustiveGenerator.filter(allElementsUnique);
            }
            return exhaustiveGenerator;
        });
    }

    public static Optional<ExhaustiveGenerator<String>> strings(Arbitrary<Character> characterArbitrary, int minLength, int maxLength, long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(characterArbitrary, minLength, maxLength, maxNumberOfSamples).map(listGenerator -> listGenerator.map(listOfChars -> listOfChars.stream().map(String::valueOf).collect(Collectors.joining())));
    }

    public static <T> Optional<ExhaustiveGenerator<Set<T>>> set(Arbitrary<T> elementArbitrary, int minSize, int maxSize, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = SetExhaustiveGenerator.calculateMaxCount(elementArbitrary, minSize, maxSize, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> new SetExhaustiveGenerator(elementArbitrary, (long)maxCount, minSize, maxSize));
    }

    public static <R> Optional<ExhaustiveGenerator<R>> combine(List<Arbitrary<Object>> arbitraries, Function<List<Object>, R> combinator, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = CombinedExhaustiveGenerator.calculateMaxCount(arbitraries, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> new CombinedExhaustiveGenerator((Long)maxCount, arbitraries, combinator));
    }

    public static <T> Optional<ExhaustiveGenerator<List<T>>> shuffle(List<T> values, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = PermutationExhaustiveGenerator.calculateMaxCount(values, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> new PermutationExhaustiveGenerator(values, (Long)maxCount));
    }

    public static <U, T> Optional<ExhaustiveGenerator<U>> flatMap(ExhaustiveGenerator<T> base, Function<T, Arbitrary<U>> mapper, long maxNumberOfSamples) {
        Optional<Long> optionalMaxCount = FlatMappedExhaustiveGenerator.calculateMaxCounts(base, mapper, maxNumberOfSamples);
        return optionalMaxCount.map(maxCount -> new FlatMappedExhaustiveGenerator(base, (long)maxCount, mapper));
    }

    private static class SupplierIterator<T>
    implements Iterator<T> {
        private final Supplier<T> supplier;
        private volatile boolean generated = false;

        private SupplierIterator(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public boolean hasNext() {
            return !this.generated;
        }

        @Override
        public T next() {
            if (this.generated) {
                throw new NoSuchElementException();
            }
            this.generated = true;
            return this.supplier.get();
        }
    }
}

