/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;

class ContainerGenerator<T, C>
implements RandomGenerator<C> {
    private final RandomGenerator<T> elementGenerator;
    private final Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable;
    private final Function<Random, Integer> sizeGenerator;

    ContainerGenerator(RandomGenerator<T> elementGenerator, Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable, Function<Random, Integer> sizeGenerator) {
        this.elementGenerator = elementGenerator;
        this.createShrinkable = createShrinkable;
        this.sizeGenerator = sizeGenerator;
    }

    public Shrinkable<C> next(Random random) {
        int listSize = this.sizeGenerator.apply(random);
        ArrayList<Shrinkable> list = new ArrayList<Shrinkable>();
        while (list.size() < listSize) {
            list.add(this.elementGenerator.next(random));
        }
        return this.createShrinkable.apply(list);
    }
}

