/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;

public class InjectDuplicatesGenerator<T>
implements RandomGenerator<T> {
    private final List<Long> previousSeeds = new ArrayList<Long>();
    private final RandomGenerator<T> base;
    private final double duplicateProbability;

    public InjectDuplicatesGenerator(RandomGenerator<T> base, double duplicateProbability) {
        this.base = base;
        this.duplicateProbability = duplicateProbability;
    }

    public Shrinkable<T> next(Random random) {
        long seed = this.chooseSeed(random);
        return this.base.next(new Random(seed));
    }

    long chooseSeed(Random random) {
        if (!this.previousSeeds.isEmpty() && random.nextDouble() <= this.duplicateProbability) {
            return this.randomPreviousSeed(random);
        }
        long seed = random.nextLong();
        this.previousSeeds.add(seed);
        return seed;
    }

    private long randomPreviousSeed(Random random) {
        int index = random.nextInt(this.previousSeeds.size());
        return this.previousSeeds.get(index);
    }
}

