/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.shrinking.ShrinkableBigDecimal;

public class RandomDecimalGenerators {
    public static RandomGenerator<BigDecimal> bigDecimals(Range<BigDecimal> range, int scale, BigDecimal[] partitionPoints, Function<BigDecimal, BigDecimal> shrinkingTargetCalculator) {
        if (scale < 0) {
            throw new JqwikException(String.format("Scale [%s] must be positive.", scale));
        }
        if (range.isSingular()) {
            return ignored -> Shrinkable.unshrinkable(range.min);
        }
        return RandomDecimalGenerators.partitionedGenerator(range, scale, partitionPoints, shrinkingTargetCalculator);
    }

    private static RandomGenerator<BigDecimal> partitionedGenerator(Range<BigDecimal> range, int scale, BigDecimal[] partitionPoints, Function<BigDecimal, BigDecimal> shrinkingTargetCalculator) {
        List<RandomGenerator<BigDecimal>> generators = RandomDecimalGenerators.createPartitions(range, scale, partitionPoints, shrinkingTargetCalculator);
        if (generators.size() == 1) {
            return generators.get(0);
        }
        return random -> ((RandomGenerator)generators.get(random.nextInt(generators.size()))).next(random);
    }

    private static List<RandomGenerator<BigDecimal>> createPartitions(Range<BigDecimal> range, int scale, BigDecimal[] partitionPoints, Function<BigDecimal, BigDecimal> shrinkingTargetCalculator) {
        ArrayList<RandomGenerator<BigDecimal>> partitions = new ArrayList<RandomGenerator<BigDecimal>>();
        Arrays.sort(partitionPoints);
        BigDecimal lower = (BigDecimal)range.min;
        for (BigDecimal partitionPoint : partitionPoints) {
            BigDecimal upper = partitionPoint;
            if (upper.compareTo(lower) <= 0) continue;
            if (upper.compareTo((BigDecimal)range.max) >= 0) break;
            partitions.add(RandomDecimalGenerators.createBaseGenerator(lower, upper, scale, range, shrinkingTargetCalculator));
            lower = upper;
        }
        partitions.add(RandomDecimalGenerators.createBaseGenerator(lower, (BigDecimal)range.max, scale, range, shrinkingTargetCalculator));
        return partitions;
    }

    private static RandomGenerator<BigDecimal> createBaseGenerator(BigDecimal minGenerate, BigDecimal maxGenerate, int scale, Range<BigDecimal> range, Function<BigDecimal, BigDecimal> shrinkingTargetCalculator) {
        BigInteger scaledMinTry = minGenerate.scaleByPowerOfTen(scale).toBigInteger();
        BigInteger scaledMin = new BigDecimal(scaledMinTry, scale).compareTo(minGenerate) >= 0 ? scaledMinTry : scaledMinTry.add(BigInteger.ONE);
        BigInteger scaledMaxTry = maxGenerate.scaleByPowerOfTen(scale).toBigInteger();
        BigInteger scaledMax = new BigDecimal(scaledMaxTry, scale).compareTo(maxGenerate) <= 0 ? scaledMaxTry : scaledMaxTry.subtract(BigInteger.ONE);
        return random -> {
            BigDecimal randomDecimal = RandomDecimalGenerators.generate(random, minGenerate, scale, scaledMin, scaledMax);
            while (!range.includes(randomDecimal)) {
                randomDecimal = RandomDecimalGenerators.generate(random, minGenerate, scale, scaledMin, scaledMax);
            }
            return new ShrinkableBigDecimal(randomDecimal, range, scale, (BigDecimal)shrinkingTargetCalculator.apply(randomDecimal));
        };
    }

    private static BigDecimal generate(Random random, BigDecimal minGenerate, int scale, BigInteger scaledMin, BigInteger scaledMax) {
        if (scaledMin.compareTo(scaledMax) >= 0) {
            return minGenerate;
        }
        BigInteger randomIntegral = RandomDecimalGenerators.randomIntegral(random, scaledMin, scaledMax);
        return new BigDecimal(randomIntegral, scale);
    }

    private static BigInteger randomIntegral(Random random, BigInteger min, BigInteger max) {
        BigInteger rawValue;
        BigInteger value;
        BigInteger range = max.subtract(min);
        int bits = range.bitLength();
        while ((value = (rawValue = new BigInteger(bits, random)).add(min)).compareTo(min) < 0 || value.compareTo(max) > 0) {
        }
        return value;
    }
}

