/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.engine.properties.shrinking.CollectShrinkingSequence;

public class CollectShrinkable<T>
implements Shrinkable<List<T>> {
    private final List<T> value;
    private final List<Shrinkable<T>> elements;
    private final Predicate<List<T>> until;

    public CollectShrinkable(List<Shrinkable<T>> elements, Predicate<List<T>> until) {
        this.value = this.createValue(elements);
        this.elements = elements;
        this.until = until;
    }

    public List<T> value() {
        return this.value;
    }

    private List<T> createValue(List<Shrinkable<T>> elements) {
        return elements.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    public ShrinkingSequence<List<T>> shrink(Falsifier<List<T>> falsifier) {
        return new CollectShrinkingSequence<T>(this.elements, this.until, falsifier);
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.forCollection(this.elements);
    }
}

