/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.engine.properties.arbitraries.GenerationError;
import net.jqwik.engine.properties.shrinking.ShrinkElementsSequence;

public class CombinedShrinkable<T>
implements Shrinkable<T> {
    private final List<Shrinkable<Object>> shrinkables;
    private final Function<List<Object>, T> combinator;
    private final T value;

    public CombinedShrinkable(List<Shrinkable<Object>> shrinkables, Function<List<Object>, T> combinator) {
        this.shrinkables = shrinkables;
        this.combinator = combinator;
        this.value = combinator.apply(this.toValues(shrinkables));
    }

    public T value() {
        return this.value;
    }

    private List<Object> toValues(List<Shrinkable<Object>> shrinkables) {
        return shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    public ShrinkingSequence<T> shrink(Falsifier<T> falsifier) {
        return new CombinedShrinkingSequence(falsifier);
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.combine(this.shrinkables);
    }

    private class CombinedShrinkingSequence
    implements ShrinkingSequence<T> {
        private final ShrinkingSequence<List<Object>> elementsSequence;

        private CombinedShrinkingSequence(Falsifier<T> falsifier) {
            Falsifier combinedFalsifier = elements -> {
                try {
                    Object value = CombinedShrinkable.this.combinator.apply(elements);
                    return falsifier.execute(value);
                }
                catch (GenerationError generationError) {
                    return TryExecutionResult.invalid();
                }
            };
            this.elementsSequence = new ShrinkElementsSequence<Object>(CombinedShrinkable.this.shrinkables, combinedFalsifier, ShrinkingDistance::combine);
        }

        public void init(FalsificationResult<T> initialCurrent) {
            this.elementsSequence.init(FalsificationResult.falsified((Shrinkable)Shrinkable.unshrinkable(new ArrayList()), (Throwable)initialCurrent.throwable().orElse(null)));
        }

        public boolean next(Runnable count, Consumer<FalsificationResult<T>> falsifiedReporter) {
            Consumer<FalsificationResult> combinedReporter = result -> falsifiedReporter.accept(result.map(shrinkable -> shrinkable.map(CombinedShrinkable.this.combinator)));
            return this.elementsSequence.next(count, combinedReporter);
        }

        public FalsificationResult<T> current() {
            return this.elementsSequence.current().map(shrinkable -> shrinkable.map(CombinedShrinkable.this.combinator));
        }
    }
}

