/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;

public class FilteredShrinkable<T>
implements Shrinkable<T> {
    private final Shrinkable<T> toFilter;
    private final Predicate<T> filter;
    private final T value;

    public FilteredShrinkable(Shrinkable<T> toFilter, Predicate<T> filter) {
        this.toFilter = toFilter;
        this.filter = filter;
        this.value = toFilter.value();
    }

    public T value() {
        return this.value;
    }

    public ShrinkingSequence<T> shrink(Falsifier<T> falsifier) {
        return new FilteredShrinkingSequence(falsifier);
    }

    public List<Shrinkable<T>> shrinkingSuggestions() {
        return this.toFilter.shrinkingSuggestions().stream().filter(shrinkable -> this.filter.test(shrinkable.value())).collect(Collectors.toList());
    }

    public ShrinkingDistance distance() {
        return this.toFilter.distance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredShrinkable that = (FilteredShrinkable)o;
        return this.toFilter.equals(that.toFilter);
    }

    public int hashCode() {
        return this.toFilter.hashCode();
    }

    public String toString() {
        return String.format("Filtered|%s", this.toFilter);
    }

    private class FilteredShrinkingSequence
    implements ShrinkingSequence<T> {
        private final ShrinkingSequence<T> toFilterSequence;

        private FilteredShrinkingSequence(Falsifier<T> falsifier) {
            Falsifier filteredFalsifier = falsifier.withFilter(FilteredShrinkable.this.filter);
            this.toFilterSequence = FilteredShrinkable.this.toFilter.shrink(filteredFalsifier);
        }

        public boolean next(Runnable count, Consumer<FalsificationResult<T>> falsifiedReporter) {
            return this.toFilterSequence.next(count, falsifiedReporter);
        }

        public FalsificationResult<T> current() {
            return this.toFilterSequence.current().filter(FilteredShrinkable.this.filter);
        }

        public void init(FalsificationResult<T> initialCurrent) {
            this.toFilterSequence.init(initialCurrent);
        }
    }
}

