/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.shrinking.ShrinkOneElementAfterTheOtherSequence;

public class ShrinkElementsSequence<T>
implements ShrinkingSequence<List<T>> {
    private final List<Shrinkable<T>> currentShrinkables;
    private final Falsifier<List<T>> listFalsifier;
    private final Function<List<Shrinkable<T>>, ShrinkingDistance> distanceFunction;
    private final List<Tuple.Tuple2<Integer, Integer>> tableOfDuplicates;
    private ShrinkOneElementAfterTheOtherSequence<T> nextSequence;
    private Throwable currentThrowable;

    public ShrinkElementsSequence(List<Shrinkable<T>> currentShrinkables, Falsifier<List<T>> listFalsifier, Function<List<Shrinkable<T>>, ShrinkingDistance> distanceFunction) {
        this.currentShrinkables = currentShrinkables;
        this.listFalsifier = listFalsifier;
        this.distanceFunction = distanceFunction;
        this.tableOfDuplicates = ShrinkElementsSequence.buildTableOfDuplicates(currentShrinkables);
    }

    private static <T> List<Tuple.Tuple2<Integer, Integer>> buildTableOfDuplicates(List<Shrinkable<T>> shrinkables) {
        ArrayList<Tuple.Tuple2<Integer, Integer>> indicesOfDuplicateValues = new ArrayList<Tuple.Tuple2<Integer, Integer>>();
        for (int i = 0; i < shrinkables.size(); ++i) {
            for (int j = i + 1; j < shrinkables.size(); ++j) {
                Shrinkable<T> jShrinkable;
                Shrinkable<T> iShrinkable = shrinkables.get(i);
                if (!ShrinkElementsSequence.areDuplicates(iShrinkable, jShrinkable = shrinkables.get(j))) continue;
                indicesOfDuplicateValues.add((Tuple.Tuple2<Integer, Integer>)Tuple.of((Object)i, (Object)j));
            }
        }
        return indicesOfDuplicateValues;
    }

    private static <T> boolean areDuplicates(Shrinkable<T> first, Shrinkable<T> second) {
        return Objects.equals(first.value(), second.value()) && first.getClass().equals(second.getClass());
    }

    public boolean next(Runnable count, Consumer<FalsificationResult<List<T>>> falsifiedReporter) {
        if (this.doneWithShrinkingDuplicates()) {
            return this.shrinkOneElementAfterTheOther(count, falsifiedReporter);
        }
        return this.shrinkDuplicates(count, falsifiedReporter);
    }

    public FalsificationResult<List<T>> current() {
        if (this.doneWithShrinkingDuplicates()) {
            return this.nextSequence().current();
        }
        return this.createCurrent();
    }

    private boolean doneWithShrinkingDuplicates() {
        return this.tableOfDuplicates.isEmpty();
    }

    private ShrinkOneElementAfterTheOtherSequence<T> nextSequence() {
        if (this.nextSequence == null) {
            this.nextSequence = new ShrinkOneElementAfterTheOtherSequence<T>(this.currentShrinkables, this.listFalsifier, this.distanceFunction);
            this.nextSequence.init(this.createCurrent());
        }
        return this.nextSequence;
    }

    private boolean shrinkOneElementAfterTheOther(Runnable count, Consumer<FalsificationResult<List<T>>> falsifiedReporter) {
        return this.nextSequence().next(count, falsifiedReporter);
    }

    private boolean shrinkDuplicates(Runnable count, Consumer<FalsificationResult<List<T>>> falsifiedReporter) {
        if (this.doneWithShrinkingDuplicates()) {
            return false;
        }
        Tuple.Tuple2<Integer, Integer> indexPair = this.tableOfDuplicates.get(0);
        this.tableOfDuplicates.remove(indexPair);
        if (this.shrinkPair(indexPair, count, falsifiedReporter)) {
            this.tableOfDuplicates.removeIf(pairInTable -> this.shareAnyIndex((Tuple.Tuple2<Integer, Integer>)pairInTable, indexPair));
            return true;
        }
        return this.next(count, falsifiedReporter);
    }

    private boolean shareAnyIndex(Tuple.Tuple2<Integer, Integer> pair1, Tuple.Tuple2<Integer, Integer> pair2) {
        if (((Integer)pair1.get1()).equals(pair2.get1())) {
            return true;
        }
        if (((Integer)pair1.get1()).equals(pair2.get2())) {
            return true;
        }
        if (((Integer)pair1.get2()).equals(pair2.get1())) {
            return true;
        }
        return ((Integer)pair1.get2()).equals(pair2.get2());
    }

    private boolean shrinkPair(Tuple.Tuple2<Integer, Integer> indexPair, Runnable count, Consumer<FalsificationResult<List<T>>> falsifiedReporter) {
        ArrayList<Shrinkable<T>> current = new ArrayList<Shrinkable<T>>(this.currentShrinkables);
        boolean wasShrunk = false;
        int firstIndex = (Integer)indexPair.get1();
        int secondIndex = (Integer)indexPair.get2();
        Shrinkable firstShrinkable = (Shrinkable)current.get(firstIndex);
        Shrinkable secondShrinkable = (Shrinkable)current.get(secondIndex);
        List<Tuple.Tuple2<Shrinkable<T>, Shrinkable<T>>> candidatePairs = this.suggestions(firstShrinkable, secondShrinkable);
        for (Tuple.Tuple2<Shrinkable<T>, Shrinkable<T>> candidatePair : candidatePairs) {
            Shrinkable firstShrunk = (Shrinkable)candidatePair.get1();
            Shrinkable secondShrunk = (Shrinkable)candidatePair.get2();
            ArrayList<Shrinkable<T>> toTry = new ArrayList<Shrinkable<T>>(current);
            toTry.set(firstIndex, firstShrunk);
            toTry.set(secondIndex, secondShrunk);
            FalsificationResult result = this.listFalsifier.falsify(this.toShrinkableList(toTry));
            if (result.status() != FalsificationResult.Status.FALSIFIED) continue;
            this.currentThrowable = result.throwable().orElse(null);
            count.run();
            falsifiedReporter.accept(result);
            current = toTry;
            wasShrunk = true;
            break;
        }
        if (wasShrunk) {
            this.currentShrinkables.set(firstIndex, (Shrinkable<T>)current.get(firstIndex));
            this.currentShrinkables.set(secondIndex, (Shrinkable<T>)current.get(secondIndex));
            this.shrinkPair(indexPair, count, falsifiedReporter);
        }
        return wasShrunk;
    }

    private List<Tuple.Tuple2<Shrinkable<T>, Shrinkable<T>>> suggestions(Shrinkable<T> first, Shrinkable<T> second) {
        List suggestionsFirst = first.shrinkingSuggestions();
        List suggestionsSecond = second.shrinkingSuggestions();
        ArrayList<Tuple.Tuple2<Shrinkable<T>, Shrinkable<T>>> suggestions = new ArrayList<Tuple.Tuple2<Shrinkable<T>, Shrinkable<T>>>();
        for (Shrinkable firstSuggestion : suggestionsFirst) {
            for (Shrinkable secondSuggestion : suggestionsSecond) {
                if (!ShrinkElementsSequence.areDuplicates(firstSuggestion, secondSuggestion)) continue;
                suggestions.add(Tuple.of((Object)firstSuggestion, (Object)secondSuggestion));
            }
        }
        return suggestions;
    }

    private FalsificationResult<List<T>> createCurrent() {
        return FalsificationResult.falsified(this.toShrinkableList(this.currentShrinkables), (Throwable)this.currentThrowable);
    }

    private List<T> toValueList(List<Shrinkable<T>> shrinkables) {
        return shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    private Shrinkable<List<T>> toShrinkableList(final List<Shrinkable<T>> shrinkables) {
        return new Shrinkable<List<T>>(){
            final List<T> value;
            {
                this.value = ShrinkElementsSequence.this.toValueList(shrinkables);
            }

            public List<T> value() {
                return this.value;
            }

            public ShrinkingSequence<List<T>> shrink(Falsifier<List<T>> falsifier) {
                return new ShrinkElementsSequence(shrinkables, ShrinkElementsSequence.this.listFalsifier, ShrinkElementsSequence.this.distanceFunction);
            }

            public ShrinkingDistance distance() {
                return (ShrinkingDistance)ShrinkElementsSequence.this.distanceFunction.apply(ShrinkElementsSequence.this.currentShrinkables);
            }
        };
    }

    public void init(FalsificationResult<List<T>> initialCurrent) {
        this.currentThrowable = initialCurrent.throwable().orElse(null);
    }
}

