/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.stateful;

import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequence;
import net.jqwik.api.stateful.ActionSequenceArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.stateful.ActionSequenceGenerator;

public class DefaultActionSequenceArbitrary<M>
extends AbstractArbitraryBase
implements ActionSequenceArbitrary<M> {
    private final Arbitrary<Action<M>> actionArbitrary;
    private int minSize = 1;
    private int maxSize = 0;

    public DefaultActionSequenceArbitrary(Arbitrary<? extends Action<M>> actionArbitrary) {
        this.actionArbitrary = actionArbitrary;
    }

    public ActionSequenceArbitrary<M> ofMinSize(int minSize) {
        DefaultActionSequenceArbitrary clone = (DefaultActionSequenceArbitrary)this.typedClone();
        clone.minSize = Math.max(1, minSize);
        return clone;
    }

    public ActionSequenceArbitrary<M> ofMaxSize(int maxSize) {
        DefaultActionSequenceArbitrary clone = (DefaultActionSequenceArbitrary)this.typedClone();
        clone.maxSize = Math.max(Math.max(1, maxSize), this.minSize);
        return clone;
    }

    public RandomGenerator<ActionSequence<M>> generator(int genSize) {
        int effectiveMaxSize = this.maxSize != 0 ? this.maxSize : (int)Math.max(Math.round(Math.sqrt(genSize)), 10L);
        return new ActionSequenceGenerator<M>(this.actionArbitrary, genSize, this.minSize, effectiveMaxSize);
    }
}

