/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.providers;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Functions;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.facades.TypeUsageImpl;
import net.jqwik.engine.support.GenericsClassContext;
import net.jqwik.engine.support.GenericsSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.TypeResolution;

public class FunctionArbitraryProvider
implements ArbitraryProvider {
    private static Class<?>[] EXCLUDE_TYPES = new Class[]{Iterable.class, Comparable.class};

    public boolean canProvideFor(TypeUsage targetType) {
        if (!JqwikReflectionSupport.isFunctionalType(targetType.getRawType())) {
            return false;
        }
        for (Class<?> excludedType : EXCLUDE_TYPES) {
            if (!targetType.isOfType(excludedType)) continue;
            return false;
        }
        return true;
    }

    public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
        Class functionalType = targetType.getRawType();
        TypeUsage returnType = this.getReturnType(targetType);
        return subtypeProvider.resolveAndCombine(new TypeUsage[]{returnType}).map(arbitraries -> {
            Arbitrary resultArbitrary = (Arbitrary)arbitraries.get(0);
            return Functions.function((Class)functionalType).returns(resultArbitrary);
        }).collect(Collectors.toSet());
    }

    private TypeUsage getReturnType(TypeUsage targetType) {
        Optional<Method> optionalMethod = JqwikReflectionSupport.getFunctionMethod(targetType.getRawType());
        return optionalMethod.map(method -> {
            GenericsClassContext context = GenericsSupport.contextFor(targetType);
            TypeResolution typeResolution = context.resolveReturnType((Method)method);
            return TypeUsageImpl.forResolution(typeResolution);
        }).orElse(TypeUsage.of(Void.class, (TypeUsage[])new TypeUsage[0]));
    }

    public int priority() {
        return -1;
    }
}

