/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.jqwik.engine.discovery.predicates.IsContainerAGroup;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.AnnotationSupport;

public class JqwikAnnotationSupport {
    public static List<Annotation> findAllAnnotations(AnnotatedElement element) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        List<Annotation> presentAnnotations = Arrays.asList(JqwikAnnotationSupport.getDeclaredAnnotations(element));
        annotations.addAll(presentAnnotations);
        presentAnnotations.forEach(annotation -> JqwikAnnotationSupport.appendMetaAnnotations(annotation, annotations));
        return annotations;
    }

    private static Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        if (element instanceof AnnotatedArrayType) {
            return ((AnnotatedArrayType)element).getAnnotatedGenericComponentType().getAnnotations();
        }
        return element.getAnnotations();
    }

    private static void appendMetaAnnotations(Annotation annotation, List<Annotation> collector) {
        Annotation[] metaAnnotationCandidates = annotation.annotationType().getDeclaredAnnotations();
        Arrays.stream(metaAnnotationCandidates).filter(candidate -> !JqwikAnnotationSupport.isInJavaLangAnnotationPackage(candidate.annotationType())).filter(candidate -> !JqwikAnnotationSupport.isApiAnnotation(candidate.annotationType())).filter(candidate -> !collector.contains(candidate)).forEach(metaAnnotation -> {
            collector.add((Annotation)metaAnnotation);
            JqwikAnnotationSupport.appendMetaAnnotations(metaAnnotation, collector);
        });
    }

    private static boolean isApiAnnotation(Class<? extends Annotation> annotationType) {
        return annotationType == API.class;
    }

    private static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
        return annotationType != null && annotationType.getName().startsWith("java.lang.annotation");
    }

    public static <A extends Annotation> Optional<A> findAnnotationOnElementOrContainer(AnnotatedElement element, Class<A> annotationType) {
        Optional onElement = AnnotationSupport.findAnnotation((AnnotatedElement)element, annotationType);
        if (onElement.isPresent()) {
            return onElement;
        }
        if (element instanceof Member) {
            Class<?> container = ((Member)((Object)element)).getDeclaringClass();
            return JqwikAnnotationSupport.findAnnotationOnElementOrContainer(container, annotationType);
        }
        if (JqwikAnnotationSupport.isGroup(element)) {
            AnnotatedElement container = JqwikAnnotationSupport.getGroupContainer((Class)element);
            return JqwikAnnotationSupport.findAnnotationOnElementOrContainer(container, annotationType);
        }
        return Optional.empty();
    }

    private static AnnotatedElement getGroupContainer(Class<?> group) {
        return group.getDeclaringClass();
    }

    private static boolean isGroup(AnnotatedElement element) {
        if (element instanceof Class) {
            return new IsContainerAGroup().test((Class)element);
        }
        return false;
    }
}

