/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.logstash.logback.LogstashAbstractFormatter;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import net.logstash.logback.marker.LogstashMarker;
import org.slf4j.Marker;

public class LogstashFormatter
extends LogstashAbstractFormatter<ILoggingEvent, LogstashFieldNames> {
    @Deprecated
    private static final String JSON_MARKER_NAME = "JSON";
    private static final StackTraceElement DEFAULT_CALLER_DATA = new StackTraceElement("", "", "", 0);
    private boolean includeCallerInfo;
    @Deprecated
    private boolean enableContextMap;
    private String customFieldString;
    private JsonNode customFields;
    private int shortenedLoggerNameLength = -1;
    private TargetLengthBasedClassNameAbbreviator abbreviator;
    private boolean includeContext = true;
    private boolean includeMdc = true;

    public LogstashFormatter(ContextAware contextAware) {
        this(contextAware, false);
    }

    public LogstashFormatter(ContextAware contextAware, boolean includeCallerInfo) {
        this(contextAware, includeCallerInfo, null);
        this.includeCallerInfo = includeCallerInfo;
    }

    public LogstashFormatter(ContextAware contextAware, boolean includeCallerInfo, JsonNode customFields) {
        super(contextAware, new LogstashFieldNames());
        this.includeCallerInfo = includeCallerInfo;
        this.customFields = customFields;
    }

    @Override
    public void start() {
        super.start();
        this.initializeCustomFields();
    }

    private void initializeCustomFields() {
        if (this.customFieldString != null) {
            try {
                this.customFields = (JsonNode)this.getJsonFactory().createParser(this.customFieldString).readValueAsTree();
            }
            catch (IOException e) {
                this.contextAware.addError("Failed to parse custom fields [" + this.customFieldString + "]", (Throwable)e);
            }
        }
    }

    @Override
    protected void writeValueToGenerator(JsonGenerator generator, ILoggingEvent event, Context context) throws IOException {
        generator.writeStartObject();
        this.writeLogstashFields(generator, event);
        this.writeLoggerFields(generator, event);
        this.writeCallerDataFieldsIfNecessary(generator, event);
        this.writeStackTraceFieldIfNecessary(generator, event);
        this.writeContextPropertiesIfNecessary(generator, context);
        this.writeJsonMessageFieldIfNecessary(generator, event);
        this.writeMdcPropertiesIfNecessary(generator, event);
        this.writeContextMapFieldsIfNecessary(generator, event);
        this.writeGlobalCustomFields(generator);
        this.writeTagsIfNecessary(generator, event);
        this.writeLogstashMarkerIfNecessary(generator, event.getMarker());
        generator.writeEndObject();
        generator.flush();
    }

    private void writeLogstashFields(JsonGenerator generator, ILoggingEvent event) throws IOException {
        this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getTimestamp(), ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(event.getTimeStamp()));
        this.writeNumberField(generator, ((LogstashFieldNames)this.fieldNames).getVersion(), 1);
        this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getMessage(), event.getFormattedMessage());
    }

    private void writeLoggerFields(JsonGenerator generator, ILoggingEvent event) throws IOException {
        if (this.shortenedLoggerNameLength >= 0) {
            this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getLogger(), this.abbreviator.abbreviate(event.getLoggerName()));
        } else {
            this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getLogger(), event.getLoggerName());
        }
        this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getThread(), event.getThreadName());
        this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getLevel(), event.getLevel().toString());
        this.writeNumberField(generator, ((LogstashFieldNames)this.fieldNames).getLevelValue(), event.getLevel().toInt());
    }

    private void writeCallerDataFieldsIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        if (this.includeCallerInfo) {
            StackTraceElement callerData = this.extractCallerData(event);
            if (((LogstashFieldNames)this.fieldNames).getCaller() != null) {
                generator.writeObjectFieldStart(((LogstashFieldNames)this.fieldNames).getCaller());
            }
            this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getCallerClass(), callerData.getClassName());
            this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getCallerMethod(), callerData.getMethodName());
            this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getCallerFile(), callerData.getFileName());
            this.writeNumberField(generator, ((LogstashFieldNames)this.fieldNames).getCallerLine(), callerData.getLineNumber());
            if (((LogstashFieldNames)this.fieldNames).getCaller() != null) {
                generator.writeEndObject();
            }
        }
    }

    private void writeStackTraceFieldIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null) {
            this.writeStringField(generator, ((LogstashFieldNames)this.fieldNames).getStackTrace(), ThrowableProxyUtil.asString((IThrowableProxy)throwableProxy));
        }
    }

    private void writeContextPropertiesIfNecessary(JsonGenerator generator, Context context) throws IOException {
        if (context != null && this.includeContext) {
            if (((LogstashFieldNames)this.fieldNames).getContext() != null) {
                generator.writeObjectFieldStart(((LogstashFieldNames)this.fieldNames).getContext());
            }
            this.writeMapEntries(generator, context.getCopyOfPropertyMap());
            if (((LogstashFieldNames)this.fieldNames).getContext() != null) {
                generator.writeEndObject();
            }
        }
    }

    @Deprecated
    private void writeJsonMessageFieldIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        Marker marker = event.getMarker();
        if (marker != null && marker.contains(JSON_MARKER_NAME)) {
            generator.writeFieldName("json_message");
            generator.writeObject((Object)event.getArgumentArray());
        }
    }

    private void writeMdcPropertiesIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        Map mdcProperties;
        if (this.includeMdc && (mdcProperties = event.getMDCPropertyMap()) != null && !mdcProperties.isEmpty()) {
            if (((LogstashFieldNames)this.fieldNames).getMdc() != null) {
                generator.writeObjectFieldStart(((LogstashFieldNames)this.fieldNames).getMdc());
            }
            this.writeMapEntries(generator, mdcProperties);
            if (((LogstashFieldNames)this.fieldNames).getMdc() != null) {
                generator.writeEndObject();
            }
        }
    }

    @Deprecated
    private void writeContextMapFieldsIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        Object[] args;
        if (this.enableContextMap && (args = event.getArgumentArray()) != null && args.length > 0 && args[args.length - 1] instanceof Map) {
            Map contextMap = (Map)args[args.length - 1];
            this.writeMapEntries(generator, contextMap);
        }
    }

    private void writeGlobalCustomFields(JsonGenerator generator) throws IOException {
        this.writeFieldsOfNode(generator, this.customFields);
    }

    private void writeTagsIfNecessary(JsonGenerator generator, ILoggingEvent event) throws IOException {
        boolean hasWrittenStart = false;
        Marker marker = event.getMarker();
        if (marker != null) {
            hasWrittenStart = this.writeTagIfNecessary(generator, hasWrittenStart, marker);
        }
        if (hasWrittenStart) {
            generator.writeEndArray();
        }
    }

    private boolean writeTagIfNecessary(JsonGenerator generator, boolean hasWrittenStart, Marker marker) throws IOException {
        if (!marker.getName().equals(JSON_MARKER_NAME) && !this.isLogstashMarker(marker)) {
            if (!hasWrittenStart) {
                generator.writeArrayFieldStart(((LogstashFieldNames)this.fieldNames).getTags());
                hasWrittenStart = true;
            }
            generator.writeString(marker.getName());
        }
        if (marker.hasReferences()) {
            for (Marker next : marker) {
                hasWrittenStart |= this.writeTagIfNecessary(generator, hasWrittenStart, next);
            }
        }
        return hasWrittenStart;
    }

    private boolean isLogstashMarker(Marker marker) {
        return marker instanceof LogstashMarker;
    }

    private void writeLogstashMarkerIfNecessary(JsonGenerator generator, Marker marker) throws IOException {
        if (marker != null) {
            if (this.isLogstashMarker(marker)) {
                ((LogstashMarker)marker).writeTo(generator);
            }
            if (marker.hasReferences()) {
                for (Marker next : marker) {
                    this.writeLogstashMarkerIfNecessary(generator, next);
                }
            }
        }
    }

    private StackTraceElement extractCallerData(ILoggingEvent event) {
        StackTraceElement[] ste = event.getCallerData();
        if (ste == null || ste.length == 0) {
            return DEFAULT_CALLER_DATA;
        }
        return ste[0];
    }

    private void writeFieldsOfNode(JsonGenerator generator, JsonNode node) throws IOException {
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                generator.writeFieldName((String)field.getKey());
                generator.writeTree((TreeNode)field.getValue());
            }
        }
    }

    public boolean isIncludeCallerInfo() {
        return this.includeCallerInfo;
    }

    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.includeCallerInfo = includeCallerInfo;
    }

    public void setCustomFieldsFromString(String customFields) {
        this.customFieldString = customFields;
        if (this.isStarted()) {
            this.initializeCustomFields();
        }
    }

    public void setCustomFields(JsonNode customFields) {
        this.customFields = customFields;
    }

    public JsonNode getCustomFields() {
        return this.customFields;
    }

    public int getShortenedLoggerNameLength() {
        return this.shortenedLoggerNameLength;
    }

    public void setShortenedLoggerNameLength(int length) {
        this.shortenedLoggerNameLength = length;
        this.abbreviator = new TargetLengthBasedClassNameAbbreviator(this.shortenedLoggerNameLength);
    }

    public boolean isIncludeMdc() {
        return this.includeMdc;
    }

    public void setIncludeMdc(boolean includeMdc) {
        this.includeMdc = includeMdc;
    }

    public boolean isIncludeContext() {
        return this.includeContext;
    }

    public void setIncludeContext(boolean includeContext) {
        this.includeContext = includeContext;
    }

    @Deprecated
    public boolean isEnableContextMap() {
        return this.enableContextMap;
    }

    @Deprecated
    public void setEnableContextMap(boolean enableContextMap) {
        this.enableContextMap = enableContextMap;
    }
}

