/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.gradle.api.internal.PropertiesTransformer;
import org.gradle.plugins.ide.internal.generator.PropertiesPersistableConfigurationObject;

public class JdtApt
extends PropertiesPersistableConfigurationObject {
    private static final String GEN_SRC_DIR_KEY = "org.eclipse.jdt.apt.genSrcDir";
    private static final String GEN_TEST_SRC_DIR_KEY = "org.eclipse.jdt.apt.genTestSrcDir";
    private static final String RECONCILE_ENABLED_KEY = "org.eclipse.jdt.apt.reconcileEnabled";
    private static final String PROCESSOR_OPTIONS_KEY_PREFIX = "org.eclipse.jdt.apt.processorOptions/";
    private static final String PROCESSOR_OPTION_NULLVALUE = "org.eclipse.jdt.apt.NULLVALUE";
    private boolean aptEnabled;
    @Nullable
    private String genSrcDir;
    @Nullable
    private String genTestSrcDir;
    private boolean reconcileEnabled;
    private Map<String, String> processorOptions = new LinkedHashMap<String, String>();

    JdtApt(PropertiesTransformer transformer) {
        super(transformer);
    }

    protected String getDefaultResourceName() {
        return "defaultJdtAptPrefs.properties";
    }

    protected void load(Properties properties) {
        this.genSrcDir = properties.getProperty(GEN_SRC_DIR_KEY);
        this.genTestSrcDir = properties.getProperty(GEN_TEST_SRC_DIR_KEY);
        this.reconcileEnabled = Boolean.parseBoolean(RECONCILE_ENABLED_KEY);
        for (String name : properties.stringPropertyNames()) {
            if (!name.startsWith(PROCESSOR_OPTIONS_KEY_PREFIX)) continue;
            String value = properties.getProperty(name);
            this.processorOptions.put(name.substring(PROCESSOR_OPTIONS_KEY_PREFIX.length()), PROCESSOR_OPTION_NULLVALUE.equals(value) ? null : value);
        }
    }

    protected void store(Properties properties) {
        properties.setProperty("org.eclipse.jdt.apt.aptEnabled", Boolean.toString(this.isAptEnabled()));
        properties.setProperty(GEN_SRC_DIR_KEY, this.getGenSrcDir());
        properties.setProperty(GEN_TEST_SRC_DIR_KEY, this.getGenTestSrcDir());
        properties.setProperty(RECONCILE_ENABLED_KEY, Boolean.toString(this.isReconcileEnabled()));
        for (String string : properties.stringPropertyNames()) {
            if (!string.startsWith(PROCESSOR_OPTIONS_KEY_PREFIX) || this.getProcessorOptions().containsKey(string.substring(PROCESSOR_OPTIONS_KEY_PREFIX.length()))) continue;
            properties.remove(string);
        }
        for (Map.Entry entry : this.getProcessorOptions().entrySet()) {
            properties.setProperty(PROCESSOR_OPTIONS_KEY_PREFIX + (String)entry.getKey(), entry.getValue() == null ? PROCESSOR_OPTION_NULLVALUE : (String)entry.getValue());
        }
    }

    public boolean isAptEnabled() {
        return this.aptEnabled;
    }

    public void setAptEnabled(boolean aptEnabled) {
        this.aptEnabled = aptEnabled;
    }

    @Nullable
    public String getGenSrcDir() {
        return this.genSrcDir;
    }

    public void setGenSrcDir(@Nullable String genSrcDir) {
        this.genSrcDir = genSrcDir;
    }

    @Nullable
    public String getGenTestSrcDir() {
        return this.genTestSrcDir;
    }

    public void setGenTestSrcDir(@Nullable String genTestSrcDir) {
        this.genTestSrcDir = genTestSrcDir;
    }

    public boolean isReconcileEnabled() {
        return this.reconcileEnabled;
    }

    public void setReconcileEnabled(boolean reconcileEnabled) {
        this.reconcileEnabled = reconcileEnabled;
    }

    public Map<String, String> getProcessorOptions() {
        return this.processorOptions;
    }
}

