/*
 * Decompiled with CFR 0.152.
 */
package narou4j.network;

import java.io.IOException;
import java.util.Map;
import narou4j.network.NarouUrlBuilder;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class NarouApiClient {
    private OkHttpClient client = new OkHttpClient();

    public Response getNovels(Map<String, String> params) {
        HttpUrl.Builder builder = NarouUrlBuilder.buildApiUrl();
        for (String key : params.keySet()) {
            builder.addQueryParameter(key, params.get(key));
        }
        return this.enqueue(builder);
    }

    public Response getRanking(Map<String, String> params) {
        HttpUrl.Builder builder = NarouUrlBuilder.buildRankingUrl();
        for (String key : params.keySet()) {
            builder.addQueryParameter(key, params.get(key));
        }
        return this.enqueue(builder);
    }

    public Response getRankinDetail(Map<String, String> params) {
        HttpUrl.Builder builder = NarouUrlBuilder.buildRankinDetail();
        for (String key : params.keySet()) {
            builder.addQueryParameter(key, params.get(key));
        }
        return this.enqueue(builder);
    }

    public Response getNovelTable(String ncode) {
        return this.enqueue(NarouUrlBuilder.buildNovelTableUrl(ncode));
    }

    public Response getNovelBody(String ncode, int page) {
        return this.enqueue(NarouUrlBuilder.buildNovelTableUrl(ncode).addPathSegment(String.valueOf(page)));
    }

    private Response enqueue(HttpUrl.Builder builder) {
        Request request = new Request.Builder().url(builder.build()).get().build();
        Call call = this.client.newCall(request);
        try {
            return call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

