/*
 * Decompiled with CFR 0.152.
 */
package narou4j.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import narou4j.enums.RankingType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NovelRank
implements Serializable {
    private RankingType rankingType;
    private String ncode;
    private Date date;
    private String rtype;
    private int pt;
    private int rank;
    private SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");

    public RankingType getRankingType() {
        return this.rankingType;
    }

    public void setRankingType(RankingType rankingType) {
        this.rankingType = rankingType;
    }

    public String getNcode() {
        return this.ncode;
    }

    public void setNcode(String ncode) {
        this.ncode = ncode;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDateString() {
        return this.format.format(this.date);
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDate(String date) {
        try {
            this.date = this.format.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public String getRtype() {
        return this.rtype;
    }

    public void setRtype(String rtype) {
        this.rtype = rtype;
        String[] rtypeSplit = rtype.split("-");
        switch (rtypeSplit[1]) {
            case "d": {
                this.rankingType = RankingType.DAILY;
                break;
            }
            case "w": {
                this.rankingType = RankingType.WEEKLY;
                break;
            }
            case "m": {
                this.rankingType = RankingType.MONTHLY;
                break;
            }
            case "q": {
                this.rankingType = RankingType.QUARTET;
            }
        }
        try {
            this.date = this.format.parse(rtypeSplit[0]);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public int getPt() {
        return this.pt;
    }

    public void setPt(int pt) {
        this.pt = pt;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public String toString() {
        return "NovelRank{rankingType=" + (Object)((Object)this.rankingType) + ", ncode='" + this.ncode + '\'' + ", date=" + this.date + ", rtype='" + this.rtype + '\'' + ", pt=" + this.pt + ", rank=" + this.rank + '}';
    }
}

