/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.map.Function;
import net.openhft.chronicle.map.ReaderWithSize;
import net.openhft.chronicle.map.SerializationBuilder;
import net.openhft.chronicle.map.StatelessChronicleMap;
import net.openhft.chronicle.map.UnaryOperator;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.Work;
import net.openhft.chronicle.map.WriterWithSize;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatelessServerConnector<K, V> {
    public static final boolean MAP_SUPPORTS_BYTES = true;
    private static final Logger LOG = LoggerFactory.getLogger((String)StatelessServerConnector.class.getName());
    public static final StatelessChronicleMap.EventId[] VALUES = StatelessChronicleMap.EventId.values();
    public static final int SIZE_OF_IS_EXCEPTION = 1;
    public static final int HEADER_SIZE = 13;
    @NotNull
    private final ReaderWithSize<K> keyReaderWithSize;
    @NotNull
    private final WriterWithSize<K> keyWriterWithSize;
    @NotNull
    private final ReaderWithSize<V> valueReaderWithSize;
    @NotNull
    private final WriterWithSize<V> valueWriterWithSize;
    @NotNull
    private final VanillaChronicleMap<K, ?, ?, V, ?, ?> map;
    private final double maxEntrySizeBytes;

    StatelessServerConnector(SerializationBuilder<K> keySerializationBuilder, SerializationBuilder<V> valueSerializationBuilder, @NotNull VanillaChronicleMap<K, ?, ?, V, ?, ?> map, int maxEntrySizeBytes) {
        this.keyReaderWithSize = new ReaderWithSize<K>(keySerializationBuilder);
        this.keyWriterWithSize = new WriterWithSize<K>(keySerializationBuilder);
        this.valueReaderWithSize = new ReaderWithSize<V>(valueSerializationBuilder);
        this.valueWriterWithSize = new WriterWithSize<V>(valueSerializationBuilder);
        this.map = map;
        this.maxEntrySizeBytes = maxEntrySizeBytes;
    }

    @Nullable
    Work processStatelessEvent(byte eventId, @NotNull Bytes writer, @NotNull ByteBufferBytes reader) {
        StatelessChronicleMap.EventId event = VALUES[eventId];
        long transactionId = reader.readLong();
        long timestamp = transactionId / 10000L;
        byte identifier = reader.readByte();
        int headerSize = reader.readInt();
        reader.skip((long)headerSize);
        switch (event) {
            case KEY_SET: {
                return this.keySet((Bytes)reader, writer, transactionId);
            }
            case VALUES: {
                return this.values((Bytes)reader, writer, transactionId);
            }
            case ENTRY_SET: {
                return this.entrySet((Bytes)reader, writer, transactionId);
            }
            case PUT_WITHOUT_ACC: {
                return this.put((Bytes)reader, timestamp, identifier);
            }
            case PUT_ALL_WITHOUT_ACC: {
                return this.putAll((Bytes)reader, timestamp, identifier);
            }
            case REMOVE_WITHOUT_ACC: {
                return this.remove((Bytes)reader, timestamp, identifier);
            }
        }
        long sizeLocation = this.reflectTransactionId(writer, transactionId);
        switch (event) {
            case LONG_SIZE: {
                return this.longSize(writer, sizeLocation);
            }
            case IS_EMPTY: {
                return this.isEmpty(writer, sizeLocation);
            }
            case CONTAINS_KEY: {
                return this.containsKey((Bytes)reader, writer, sizeLocation);
            }
            case CONTAINS_VALUE: {
                return this.containsValue((Bytes)reader, writer, sizeLocation);
            }
            case GET: {
                return this.get((Bytes)reader, writer, sizeLocation, timestamp);
            }
            case PUT: {
                return this.put((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case REMOVE: {
                return this.remove((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case CLEAR: {
                return this.clear(writer, sizeLocation, timestamp, identifier);
            }
            case REPLACE: {
                return this.replace((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case REPLACE_WITH_OLD_AND_NEW_VALUE: {
                return this.replaceWithOldAndNew((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case PUT_IF_ABSENT: {
                return this.putIfAbsent((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case REMOVE_WITH_VALUE: {
                return this.removeWithValue((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case TO_STRING: {
                return this.toString(writer, sizeLocation);
            }
            case PUT_ALL: {
                return this.putAll((Bytes)reader, writer, sizeLocation, timestamp, identifier);
            }
            case HASH_CODE: {
                return this.hashCode(writer, sizeLocation);
            }
            case MAP_FOR_KEY: {
                return this.mapForKey(reader, writer, sizeLocation);
            }
            case PUT_MAPPED: {
                return this.putMapped(reader, writer, sizeLocation);
            }
        }
        throw new IllegalStateException("unsupported event=" + (Object)((Object)event));
    }

    @Nullable
    public Work mapForKey(@NotNull ByteBufferBytes reader, @NotNull Bytes writer, long sizeLocation) {
        K key = this.keyReaderWithSize.read((Bytes)reader, null);
        Function function = (Function)reader.readObject();
        try {
            Object result = this.map.getMapped(key, function);
            writer.writeObject(result);
        }
        catch (Throwable e) {
            LOG.info("", e);
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    public Work putMapped(@NotNull ByteBufferBytes reader, @NotNull Bytes writer, long sizeLocation) {
        K key = this.keyReaderWithSize.read((Bytes)reader, null);
        UnaryOperator unaryOperator = (UnaryOperator)reader.readObject();
        try {
            V result = this.map.putMapped(key, unaryOperator);
            writer.writeObject(result);
        }
        catch (Throwable e) {
            LOG.info("", e);
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work removeWithValue(Bytes reader, @NotNull Bytes writer, long sizeLocation, long timestamp, byte id) {
        try {
            writer.writeBoolean(this.map.removeWithValue(reader));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work replaceWithOldAndNew(Bytes reader, @NotNull Bytes writer, long sizeLocation, long timestamp, byte id) {
        try {
            this.map.replaceWithOldAndNew(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work longSize(@NotNull Bytes writer, long sizeLocation) {
        try {
            writer.writeLong(this.map.longSize());
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work hashCode(@NotNull Bytes writer, long sizeLocation) {
        try {
            writer.writeInt(this.map.hashCode());
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work toString(@NotNull Bytes writer, long sizeLocation) {
        String str;
        long remaining = writer.remaining();
        try {
            str = this.map.toString();
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        assert (remaining > 4L);
        String result = (long)str.length() < remaining ? str : str.substring(0, (int)(remaining - 4L)) + "...";
        writer.writeObject((Object)result);
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work sendException(@NotNull Bytes writer, long sizeLocation, @NotNull Throwable e) {
        writer.position(sizeLocation + 13L);
        this.writeException(writer, e);
        this.writeSizeAndFlags(sizeLocation + 8L, true, writer);
        e.printStackTrace();
        return null;
    }

    @Nullable
    private Work isEmpty(@NotNull Bytes writer, long sizeLocation) {
        try {
            writer.writeBoolean(this.map.isEmpty());
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work containsKey(Bytes reader, @NotNull Bytes writer, long sizeLocation) {
        try {
            writer.writeBoolean(this.map.containsKey(reader));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work containsValue(Bytes reader, @NotNull Bytes writer, long sizeLocation) {
        V v = this.valueReaderWithSize.read(reader, null);
        try {
            writer.writeBoolean(this.map.containsValue(v));
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work get(Bytes reader, @NotNull Bytes writer, long sizeLocation, long transactionId) {
        try {
            this.map.get(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work put(Bytes reader, long timestamp, byte id) {
        this.map.put(reader);
        return null;
    }

    @Nullable
    private Work put(Bytes reader, @NotNull Bytes writer, long sizeLocation, long timestamp, byte id) {
        try {
            this.map.put(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work remove(Bytes reader, long timestamp, byte id) {
        this.map.removeKeyAsBytes(reader);
        return null;
    }

    @Nullable
    private Work remove(Bytes reader, @NotNull Bytes writer, long sizeLocation, long timestamp, byte id) {
        try {
            this.map.remove(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work putAll(@NotNull Bytes reader, @NotNull Bytes writer, long sizeLocation, long timestamp, byte id) {
        try {
            this.map.putAll(reader);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work putAll(@NotNull Bytes reader, long timestamp, byte id) {
        this.map.putAll(reader);
        return null;
    }

    @Nullable
    private Work clear(@NotNull Bytes writer, long sizeLocation, long timestamp, byte id) {
        try {
            this.map.clear();
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work values(@NotNull Bytes reader, @NotNull Bytes writer, final long transactionId) {
        Collection values;
        try {
            values = this.map.values();
        }
        catch (Throwable e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator iterator = values.iterator();
        return new Work(){

            @Override
            public boolean doWork(@NotNull Bytes out) {
                long sizeLocation = StatelessServerConnector.this.header(out, transactionId);
                ThreadLocalCopies copies = StatelessServerConnector.this.valueWriterWithSize.getCopies(null);
                Object valueWriter = StatelessServerConnector.this.valueWriterWithSize.writerForLoop(copies);
                int count = 0;
                while (iterator.hasNext()) {
                    if ((double)out.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                        StatelessServerConnector.this.writeHeader(out, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    StatelessServerConnector.this.valueWriterWithSize.writeInLoop(out, iterator.next(), valueWriter, copies);
                }
                StatelessServerConnector.this.writeHeader(out, sizeLocation, count, false);
                return true;
            }
        };
    }

    @Nullable
    private Work keySet(@NotNull Bytes reader, @NotNull Bytes writer, final long transactionId) {
        Set ks;
        try {
            ks = this.map.keySet();
        }
        catch (Throwable e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator iterator = ks.iterator();
        return new Work(){

            @Override
            public boolean doWork(@NotNull Bytes out) {
                long sizeLocation = StatelessServerConnector.this.header(out, transactionId);
                ThreadLocalCopies copies = StatelessServerConnector.this.keyWriterWithSize.getCopies(null);
                Object keyWriter = StatelessServerConnector.this.keyWriterWithSize.writerForLoop(copies);
                int count = 0;
                while (iterator.hasNext()) {
                    if ((double)out.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                        StatelessServerConnector.this.writeHeader(out, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    Object key = iterator.next();
                    StatelessServerConnector.this.keyWriterWithSize.writeInLoop(out, key, keyWriter, copies);
                }
                StatelessServerConnector.this.writeHeader(out, sizeLocation, count, false);
                return true;
            }
        };
    }

    @Nullable
    private Work entrySet(@NotNull Bytes reader, @NotNull Bytes writer, final long transactionId) {
        Set<Map.Entry<K, V>> entries;
        try {
            entries = this.map.entrySet();
        }
        catch (Throwable e) {
            return this.sendException(reader, writer, e);
        }
        final Iterator<Map.Entry<K, V>> iterator = entries.iterator();
        return new Work(){

            @Override
            public boolean doWork(@NotNull Bytes out) {
                if ((double)out.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                    return false;
                }
                long sizeLocation = StatelessServerConnector.this.header(out, transactionId);
                ThreadLocalCopies copies = StatelessServerConnector.this.keyWriterWithSize.getCopies(null);
                Object keyWriter = StatelessServerConnector.this.keyWriterWithSize.writerForLoop(copies);
                copies = StatelessServerConnector.this.valueWriterWithSize.getCopies(copies);
                Object valueWriter = StatelessServerConnector.this.valueWriterWithSize.writerForLoop(copies);
                int count = 0;
                while (iterator.hasNext()) {
                    if ((double)out.remaining() <= StatelessServerConnector.this.maxEntrySizeBytes) {
                        StatelessServerConnector.this.writeHeader(out, sizeLocation, count, true);
                        return false;
                    }
                    ++count;
                    Map.Entry next = (Map.Entry)iterator.next();
                    StatelessServerConnector.this.keyWriterWithSize.writeInLoop(out, next.getKey(), keyWriter, copies);
                    StatelessServerConnector.this.valueWriterWithSize.writeInLoop(out, next.getValue(), valueWriter, copies);
                }
                StatelessServerConnector.this.writeHeader(out, sizeLocation, count, false);
                return true;
            }
        };
    }

    @Nullable
    private Work putIfAbsent(Bytes reader, @NotNull Bytes writer, long sizeLocation, long timestamp, byte id) {
        try {
            this.map.putIfAbsent(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    @Nullable
    private Work replace(Bytes reader, @NotNull Bytes writer, long sizeLocation, long timestamp, byte id) {
        try {
            this.map.replaceKV(reader, writer);
        }
        catch (Throwable e) {
            return this.sendException(writer, sizeLocation, e);
        }
        this.writeSizeAndFlags(sizeLocation, false, writer);
        return null;
    }

    private long reflectTransactionId(@NotNull Bytes writer, long transactionId) {
        long sizeLocation = writer.position();
        writer.skip(4L);
        assert (transactionId != 0L);
        writer.writeLong(transactionId);
        writer.writeBoolean(false);
        return sizeLocation;
    }

    private void writeSizeAndFlags(long locationOfSize, boolean isException, @NotNull Bytes out) {
        long size = out.position() - locationOfSize;
        out.writeInt(locationOfSize, (int)size);
        out.writeBoolean(locationOfSize + 4L + 8L, isException);
        long pos = out.position();
        long limit = out.limit();
        if (LOG.isDebugEnabled()) {
            out.position(locationOfSize);
            out.limit(pos);
            LOG.info("Sending to the stateless client, bytes=" + AbstractBytes.toHex((Bytes)out) + "," + "len=" + out.remaining());
            out.limit(limit);
            out.position(pos);
        }
    }

    private void writeException(@NotNull Bytes out, Throwable e) {
        out.writeObject((Object)e);
    }

    @NotNull
    private Map<K, V> readEntries(@NotNull Bytes reader) {
        long numberOfEntries = reader.readStopBit();
        HashMap<K, V> result = new HashMap<K, V>();
        ThreadLocalCopies copies = this.keyReaderWithSize.getCopies(null);
        BytesReader<K> keyReader = this.keyReaderWithSize.readerForLoop(copies);
        copies = this.valueReaderWithSize.getCopies(copies);
        BytesReader<V> valueReader = this.valueReaderWithSize.readerForLoop(copies);
        for (long i = 0L; i < numberOfEntries; ++i) {
            K key = this.keyReaderWithSize.readInLoop(reader, keyReader);
            V value = this.valueReaderWithSize.readInLoop(reader, valueReader);
            result.put(key, value);
        }
        return result;
    }

    @Nullable
    private Work sendException(@NotNull Bytes reader, @NotNull Bytes writer, @NotNull Throwable e) {
        long sizeLocation = this.reflectTransactionId(writer, reader.readLong());
        return this.sendException(writer, sizeLocation, e);
    }

    private long header(@NotNull Bytes writer, long transactionId) {
        long sizeLocation = writer.position();
        writer.skip(4L);
        writer.writeLong(transactionId);
        writer.skip(1L);
        writer.skip(1L);
        writer.skip(4L);
        return sizeLocation;
    }

    private void writeHeader(@NotNull Bytes writer, long sizeLocation, int count, boolean hasAnotherChunk) {
        long end = writer.position();
        int size = (int)(end - sizeLocation);
        writer.position(sizeLocation);
        writer.writeInt(size);
        writer.skip(8L);
        writer.writeBoolean(false);
        writer.writeBoolean(hasAnotherChunk);
        writer.writeInt(count);
        writer.position(end);
    }
}

