/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.collection.impl;

import net.openhft.lang.collection.HugeArray;
import net.openhft.lang.collection.HugeQueue;

public class HugeQueueImpl<T>
implements HugeQueue<T> {
    private final HugeArray<T> array;
    private final long size;
    private long start;
    private long end;

    public HugeQueueImpl(HugeArray<T> tHugeArray, long size) {
        this.array = tHugeArray;
        this.size = size;
    }

    @Override
    public boolean isFull() {
        return this.next(this.end) == this.start;
    }

    private long next(long end) {
        return (end + 1L) % this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.end == this.start;
    }

    @Override
    public boolean offer(T element) {
        if (this.isFull()) {
            return false;
        }
        this.array.set(this.end % this.size, element);
        this.end = this.next(this.end);
        return true;
    }

    @Override
    public T take() {
        if (this.isEmpty()) {
            return null;
        }
        long pos = this.start % this.size;
        this.start = this.next(this.start);
        return this.array.get(pos);
    }

    @Override
    public boolean takeCopy(T element) {
        if (this.isEmpty()) {
            return false;
        }
        this.array.get(this.start % this.size, element);
        this.start = this.next(this.start);
        return true;
    }

    @Override
    public T offer() {
        if (this.isFull()) {
            return null;
        }
        T t = this.array.get(this.end % this.size);
        this.end = this.next(this.end);
        return t;
    }

    @Override
    public void recycle(T element) {
        this.array.recycle(element);
    }
}

