/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import net.openhft.lang.Maths;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesHasher;

public enum VanillaBytesHasher implements BytesHasher
{
    INSTANCE;

    private static final long LONG_LEVEL_PRIME_MULTIPLE = -7070675565921424023L;
    private static final short SHORT_LEVEL_PRIME_MULTIPLE = 16463;
    private static final byte BYTE_LEVEL_PRIME_MULTIPLE = 87;

    @Override
    public long hash(Bytes bytes) {
        return this.hash(bytes, bytes.position(), bytes.limit());
    }

    @Override
    public long hash(Bytes bytes, long offset, long limit) {
        return Maths.hash(limit - offset == 8L ? bytes.readLong(offset) : this.hash0(bytes, offset, limit));
    }

    private long hash0(Bytes bytes, long offset, long limit) {
        long i;
        long h = 0L;
        for (i = offset; i < limit - 7L; i += 8L) {
            h = -7070675565921424023L * h + bytes.readLong(i);
        }
        while (i < limit - 1L) {
            h = 16463L * h + (long)bytes.readShort(i);
            i += 2L;
        }
        if (i < limit) {
            h = 87L * h + (long)bytes.readByte(i);
        }
        return h;
    }
}

