/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.pages.PageObject;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public enum ElementContructorForm {
    WEBDRIVER_ELEMENT_TWO_TIMEOUTS(WebDriver.class, ElementLocator.class, WebElement.class, Long.TYPE, Long.TYPE),
    WEBDRIVER_ELEMENT_SINGLE_TIMEOUT(WebDriver.class, ElementLocator.class, WebElement.class, Long.TYPE),
    WEBDRIVER_LOCATOR_TWO_TIMEOUTS(WebDriver.class, ElementLocator.class, Long.TYPE, Long.TYPE),
    WEBDRIVER_LOCATOR_SINGLE_TIMEOUT(WebDriver.class, ElementLocator.class, Long.TYPE),
    PAGE_LOCATOR_ELEMENT_SINGLE_TIMEOUT(PageObject.class, ElementLocator.class, WebElement.class, Long.TYPE),
    PAGE_LOCATOR_ELEMENT_TWO_TIMEOUTS(PageObject.class, ElementLocator.class, WebElement.class, Long.TYPE),
    PAGE_LOCATOR_TWO_TIMEOUTS(PageObject.class, ElementLocator.class, Long.TYPE, Long.TYPE),
    PAGE_LOCATOR_SINGLE_TIMEOUT(PageObject.class, ElementLocator.class, Long.TYPE),
    PAGE_ELEMENT_TWO_TIMEOUTS(PageObject.class, WebElement.class, Long.TYPE, Long.TYPE),
    PAGE_ELEMENT_SINGLE_TIMEOUT(PageObject.class, WebElement.class, Long.TYPE);

    private final List<Class> parameterTypes;

    private ElementContructorForm(Class ... parameterTypes) {
        this.parameterTypes = Arrays.asList(parameterTypes);
    }

    public static Optional<ElementContructorForm> matchingFormFor(Class ... parameterTypes) {
        for (ElementContructorForm constructorForm : ElementContructorForm.values()) {
            if (!constructorForm.parameterTypes.equals(Arrays.asList(parameterTypes))) continue;
            return Optional.of(constructorForm);
        }
        return Optional.empty();
    }

    private Optional<Constructor> findMatchingConstructorFrom(Constructor<?>[] declaredConstructors) {
        for (Constructor<?> constructor : declaredConstructors) {
            if (!this.parameterTypes.equals(Arrays.asList(constructor.getParameterTypes()))) continue;
            return Optional.of(constructor);
        }
        return Optional.empty();
    }

    public static Optional<Constructor> applicableConstructorFrom(Class implementerClass) {
        Constructor<?>[] declaredConstructors = implementerClass.getDeclaredConstructors();
        for (ElementContructorForm elementContructorForm : ElementContructorForm.values()) {
            Optional<Constructor> matchingConstructor = elementContructorForm.findMatchingConstructorFrom(declaredConstructors);
            if (!matchingConstructor.isPresent()) continue;
            return matchingConstructor;
        }
        return Optional.empty();
    }

    public static Optional<ElementContructorForm> applicableConstructor(Class implementerClass) {
        Constructor<?>[] declaredConstructors = implementerClass.getDeclaredConstructors();
        for (ElementContructorForm elementContructorForm : ElementContructorForm.values()) {
            Optional<Constructor> matchingConstructor = elementContructorForm.findMatchingConstructorFrom(declaredConstructors);
            if (!matchingConstructor.isPresent()) continue;
            return Optional.of(elementContructorForm);
        }
        return Optional.empty();
    }
}

