/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import com.google.common.base.Preconditions;
import java.nio.file.Path;
import net.serenitybdd.core.photography.Darkroom;
import net.serenitybdd.core.photography.PhotoSession;
import net.serenitybdd.core.photography.ScreenshotPhoto;
import net.thucydides.core.screenshots.BlurLevel;
import org.openqa.selenium.WebDriver;

public class PhotoSessionBooking {
    private final Darkroom darkroom;
    private WebDriver driver;
    private Path outputDirectory;
    private BlurLevel blurLevel;
    private ScrollStrategy scrollStrategy;

    public PhotoSessionBooking(Darkroom darkroom, ScrollStrategy scrollStrategy) {
        this.scrollStrategy = scrollStrategy;
        this.darkroom = darkroom;
    }

    public PhotoSessionBooking with(WebDriver driver) {
        this.driver = driver;
        return this;
    }

    public PhotoSessionBooking andWithBlurring(BlurLevel blurLevel) {
        this.blurLevel = blurLevel;
        return this;
    }

    public ScreenshotPhoto andSaveToDirectory(Path outputDirectory) {
        Preconditions.checkNotNull((Object)this.driver);
        Preconditions.checkNotNull((Object)outputDirectory);
        this.outputDirectory = outputDirectory;
        return this.inPhotoSession().takeScreenshot();
    }

    private PhotoSession inPhotoSession() {
        return new PhotoSession(this.driver, this.darkroom, this.outputDirectory, this.blurLevel, this.scrollStrategy);
    }
}

