/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.screenshots;

import java.lang.reflect.Method;
import java.util.Optional;
import net.serenitybdd.markers.DisableScreenshots;
import net.serenitybdd.markers.IsSilent;
import net.thucydides.core.annotations.Screenshots;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.model.screenshots.ScreenshotPreferencesByClass;
import net.thucydides.core.model.screenshots.StepDefinitionAnnotations;
import net.thucydides.core.reflection.StackTraceAnalyser;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.Configuration;

public class ScreenshotPermission {
    private final Configuration<Configuration> configuration;

    public ScreenshotPermission(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean areDisabledForThisAction() {
        TakeScreenshots codeLevelScreenshotConfiguration = this.methodOverride().orElse(this.taskOverride().orElse(this.classOverride().orElse(TakeScreenshots.UNDEFINED)));
        return codeLevelScreenshotConfiguration == TakeScreenshots.DISABLED;
    }

    public boolean areAllowed(TakeScreenshots takeScreenshots) {
        TakeScreenshots configuredLevel = this.methodOverride().orElse(this.taskOverride().orElse(this.classOverride().orElse(this.stepDefinitionOverride().orElse(this.configuration.getScreenshotLevel().orElse(TakeScreenshots.UNDEFINED)))));
        if (configuredLevel != TakeScreenshots.UNDEFINED) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast(configuredLevel);
        }
        return this.legacyScreenshotConfiguration(takeScreenshots);
    }

    private boolean legacyScreenshotConfiguration(TakeScreenshots takeScreenshots) {
        if (this.configuration.onlySaveFailingScreenshots()) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast(TakeScreenshots.FOR_FAILURES);
        }
        if (this.configuration.takeVerboseScreenshots()) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast(TakeScreenshots.FOR_EACH_ACTION);
        }
        return this.takeScreenshotLevel(takeScreenshots).isAtLeast(TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP);
    }

    private Optional<TakeScreenshots> methodOverride() {
        for (Method callingMethod : StackTraceAnalyser.inscopeMethodsIn((StackTraceElement[])new Throwable().getStackTrace())) {
            Optional<TakeScreenshots> overriddenScreenshotPreference = this.overriddenScreenshotPreferenceFor(callingMethod);
            if (!overriddenScreenshotPreference.isPresent()) continue;
            return overriddenScreenshotPreference;
        }
        return Optional.empty();
    }

    private Optional<TakeScreenshots> taskOverride() {
        for (Method callingMethod : StackTraceAnalyser.performAsMethodsIn((StackTraceElement[])new Throwable().getStackTrace())) {
            Optional<TakeScreenshots> overriddenScreenshotPreference = this.overriddenTaskScreenshotPreferenceFor(callingMethod);
            if (!overriddenScreenshotPreference.isPresent()) continue;
            return overriddenScreenshotPreference;
        }
        return Optional.empty();
    }

    private Optional<TakeScreenshots> stepDefinitionOverride() {
        return Optional.ofNullable(StepDefinitionAnnotations.getScreenshotPreferences());
    }

    private Optional<TakeScreenshots> classOverride() {
        Optional<Method> currentStepMethod;
        if (StepEventBus.getEventBus().isBaseStepListenerRegistered() && (currentStepMethod = StepEventBus.getEventBus().getBaseStepListener().getCurrentStepMethod()) != null && currentStepMethod.isPresent()) {
            return this.overriddenScreenshotPreferenceForClass(currentStepMethod.get().getDeclaringClass());
        }
        return Optional.empty();
    }

    private Optional<TakeScreenshots> overriddenScreenshotPreferenceForClass(Class<?> declaringClass) {
        Optional optionalScreenshotPreference = ScreenshotPreferencesByClass.forClass(declaringClass).withEnvironmentVariables(this.configuration.getEnvironmentVariables()).getScreenshotPreference();
        return optionalScreenshotPreference;
    }

    private Optional<TakeScreenshots> overriddenScreenshotPreferenceFor(Method callingMethod) {
        if (callingMethod.getAnnotation(Screenshots.class) != null) {
            return Optional.of(this.screenshotLevelFrom(callingMethod.getAnnotation(Screenshots.class)));
        }
        return Optional.empty();
    }

    private Optional<TakeScreenshots> overriddenTaskScreenshotPreferenceFor(Method callingMethod) {
        if (callingMethod.getAnnotation(Screenshots.class) != null) {
            return Optional.of(this.screenshotLevelFrom(callingMethod.getAnnotation(Screenshots.class)));
        }
        if (callingMethod.getDeclaringClass().getAnnotation(Screenshots.class) != null) {
            return Optional.of(this.screenshotLevelFrom(callingMethod.getDeclaringClass().getAnnotation(Screenshots.class)));
        }
        if (this.isSilent(callingMethod.getDeclaringClass()) || this.isABackendOperation(callingMethod.getDeclaringClass())) {
            return Optional.of(TakeScreenshots.DISABLED);
        }
        return Optional.empty();
    }

    private boolean isSilent(Class<?> declaringClass) {
        return IsSilent.class.isAssignableFrom(declaringClass);
    }

    private boolean isABackendOperation(Class<?> declaringClass) {
        return DisableScreenshots.class.isAssignableFrom(declaringClass);
    }

    private TakeScreenshots screenshotLevelFrom(Screenshots screenshots) {
        if (screenshots.disabled()) {
            return TakeScreenshots.DISABLED;
        }
        if (screenshots.onlyOnFailures()) {
            return TakeScreenshots.FOR_FAILURES;
        }
        if (screenshots.forEachAction()) {
            return TakeScreenshots.FOR_EACH_ACTION;
        }
        if (screenshots.afterEachStep()) {
            return TakeScreenshots.AFTER_EACH_STEP;
        }
        if (screenshots.beforeAndAfterEachStep()) {
            return TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP;
        }
        return TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP;
    }

    private TakeScreenshotsComparer takeScreenshotLevel(TakeScreenshots takeScreenshots) {
        return new TakeScreenshotsComparer(takeScreenshots);
    }

    private static class TakeScreenshotsComparer {
        private final TakeScreenshots takeScreenshots;

        private TakeScreenshotsComparer(TakeScreenshots takeScreenshots) {
            this.takeScreenshots = takeScreenshots;
        }

        public boolean isAtLeast(TakeScreenshots requiredLevel) {
            return this.takeScreenshots.compareTo((Enum)requiredLevel) >= 0;
        }
    }
}

