/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.serenitybdd.core.pages.PageObject;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.pages.Pages;

public class PageObjectDependencyInjector
implements DependencyInjector {
    private final Pages pages;
    EnvironmentDependencyInjector environmentDependencyInjector;
    private static final List<Field> NO_FIELDS = new ArrayList<Field>();

    public PageObjectDependencyInjector(Pages pages) {
        this.pages = pages;
        this.environmentDependencyInjector = new EnvironmentDependencyInjector();
    }

    public void injectDependenciesInto(Object target) {
        this.environmentDependencyInjector.injectDependenciesInto(target);
        List<Field> pageObjectFields = this.pageObjectFieldsIn(target);
        this.updatePageObject(target, this.pages);
        for (Field pageObjectField : this.nonAbstract(pageObjectFields)) {
            this.instantiatePageObjectIfNotAssigned(pageObjectField, target);
        }
    }

    private List<Field> nonAbstract(List<Field> pageObjectFields) {
        ArrayList<Field> concretePageObjectFields = new ArrayList<Field>();
        for (Field field : pageObjectFields) {
            if (Modifier.isAbstract(field.getType().getModifiers())) continue;
            concretePageObjectFields.add(field);
        }
        return concretePageObjectFields;
    }

    public void reset() {
    }

    private void instantiatePageObjectIfNotAssigned(Field pageObjectField, Object target) {
        try {
            pageObjectField.setAccessible(true);
            if (pageObjectField.get(target) == null) {
                Class<?> pageObjectClass = pageObjectField.getType();
                Object newPageObject = this.pages.getPage(pageObjectClass);
                this.injectDependenciesInto(newPageObject);
                pageObjectField.set(target, newPageObject);
            } else {
                this.updatePageObject(pageObjectField.get(target), this.pages);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instanciate page objects in " + target);
        }
    }

    private void updatePageObject(Object pageObject, Pages pages) {
        if (pageObject instanceof PageObject) {
            ((PageObject)pageObject).setPages(pages);
            ((PageObject)pageObject).setDriver(pages.getDriver());
        }
    }

    private List<Field> pageObjectFieldsIn(Object target) {
        if (target == null) {
            return NO_FIELDS;
        }
        Set allFields = Fields.of(target.getClass()).allFields();
        return allFields.stream().filter(field -> PageObject.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
    }
}

