/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.classpath;

import java.util.Optional;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.annotations.Narrative;
import net.thucydides.core.requirements.annotations.NarrativeFinder;
import org.apache.commons.lang3.StringUtils;

public abstract class ClassNarrative {
    public static ClassNarrative text() {
        return new ClassNarrativeText();
    }

    public static ClassNarrative type() {
        return new ClassNarrativeType();
    }

    public abstract Optional<String> definedInPath(String var1);

    protected Optional<Narrative> getClassLevelNarrativeFor(String path) {
        try {
            return NarrativeFinder.forClass(this.getClass().getClassLoader().loadClass(path));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private static String getNarrativeTextBody(Narrative narrative) {
        return Joiner.on(System.lineSeparator()).join(narrative.text());
    }

    public static class ClassNarrativeType
    extends ClassNarrative {
        @Override
        public Optional<String> definedInPath(String path) {
            Optional<Narrative> narrative = this.getClassLevelNarrativeFor(path);
            if (narrative.isPresent() && !StringUtils.isEmpty((CharSequence)narrative.get().type())) {
                return Optional.of(narrative.get().type());
            }
            return Optional.empty();
        }
    }

    public static class ClassNarrativeText
    extends ClassNarrative {
        @Override
        public Optional<String> definedInPath(String path) {
            Optional<Narrative> narrative = this.getClassLevelNarrativeFor(path);
            if (narrative.isPresent() && !StringUtils.isEmpty((CharSequence)ClassNarrative.getNarrativeTextBody(narrative.get()))) {
                return Optional.of(ClassNarrative.getNarrativeTextBody(narrative.get()));
            }
            return Optional.empty();
        }
    }
}

