/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.buildinfo;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import net.serenitybdd.core.buildinfo.BuildProperties;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfoProvider {
    private final EnvironmentVariables environmentVariables;
    private final DriverCapabilityRecord driverCapabilityRecord;
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildInfoProvider.class);

    public BuildInfoProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.driverCapabilityRecord = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    public BuildProperties getBuildProperties() {
        HashMap<String, String> generalProperties = new HashMap<String, String>();
        generalProperties.put("Default Driver", ThucydidesSystemProperty.DRIVER.from(this.environmentVariables, "firefox"));
        generalProperties.put("Operating System", System.getProperty("os.name") + " version " + System.getProperty("os.version"));
        this.addRemoteDriverPropertiesTo(generalProperties);
        this.addSaucelabsPropertiesTo(generalProperties);
        this.addCustomPropertiesTo(generalProperties);
        Map<String, Properties> driverPropertiesMap = this.driverCapabilityRecord.getDriverCapabilities();
        return new BuildProperties(generalProperties, this.driverCapabilityRecord.getDrivers(), driverPropertiesMap);
    }

    private void addRemoteDriverPropertiesTo(Map<String, String> buildProperties) {
        if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.isDefinedIn(this.environmentVariables)) {
            buildProperties.put("Remote driver", ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.from(this.environmentVariables));
            if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION.from(this.environmentVariables) != null) {
                buildProperties.put("Remote browser version", ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables) != null) {
                buildProperties.put("Remote OS", ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables));
            }
        }
    }

    private void addSaucelabsPropertiesTo(Map<String, String> buildProperties) {
        if (ThucydidesSystemProperty.SAUCELABS_URL.isDefinedIn(this.environmentVariables)) {
            buildProperties.put("Saucelabs URL", this.maskAPIKey(ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables)));
            if (ThucydidesSystemProperty.SAUCELABS_USER_ID.from(this.environmentVariables) != null) {
                buildProperties.put("Saucelabs user", ThucydidesSystemProperty.SAUCELABS_USER_ID.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables) != null) {
                buildProperties.put("Saucelabs target platform", ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.SAUCELABS_BROWSER_VERSION.from(this.environmentVariables) != null) {
                buildProperties.put("Saucelabs browser version", ThucydidesSystemProperty.SAUCELABS_BROWSER_VERSION.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables) != null) {
                buildProperties.put("Remote OS", ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables));
            }
        }
    }

    private String maskAPIKey(String url) {
        int apiKeyStart = url.indexOf(":");
        int apiKeyEnd = url.indexOf("@");
        return url.substring(0, apiKeyStart + 3) + "XXXXXXXXXXXXXXXX" + url.substring(apiKeyEnd);
    }

    private void addCustomPropertiesTo(Map<String, String> buildProperties) {
        List sysInfoKeys = this.environmentVariables.getKeys().stream().filter(key -> key.startsWith("sysinfo.")).collect(Collectors.toList());
        for (String key2 : sysInfoKeys) {
            String simplifiedKey = key2.replace("sysinfo.", "");
            String expression = EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalProperty(key2).orElse(null);
            String value = this.isGroovyExpression(expression) ? this.evaluateGroovyExpression(key2, expression) : expression;
            buildProperties.put(this.humanizedFormOf(simplifiedKey), value);
        }
    }

    private boolean isGroovyExpression(String expression) {
        return expression.startsWith("${") && expression.endsWith("}");
    }

    private String humanizedFormOf(String simplifiedKey) {
        return StringUtils.capitalize((String)StringUtils.replace((String)simplifiedKey, (String)".", (String)" "));
    }

    private String evaluateGroovyExpression(String key, String expression) {
        Binding binding = new Binding();
        binding.setVariable("env", (Object)this.environmentVariables);
        GroovyShell shell = new GroovyShell(binding);
        Object result = null;
        try {
            String groovy = expression.substring(2, expression.length() - 1);
            if (StringUtils.isNotEmpty((CharSequence)groovy)) {
                result = shell.evaluate(groovy);
            }
        }
        catch (GroovyRuntimeException e) {
            LOGGER.warn("Failed to evaluate build info expression '{0}' for key {1}", (Object)expression, (Object)key);
        }
        return result != null ? result.toString() : expression;
    }
}

