/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.guice.ThucydidesModule;

public class Injectors {
    private static Map<String, Injector> injectors = Collections.synchronizedMap(new HashMap());

    public static synchronized Injector getInjector() {
        return Injectors.getInjector((Module)new ThucydidesModule());
    }

    public static synchronized Injector getInjector(Module module) {
        String moduleClassName = module.getClass().getCanonicalName();
        Injector injector = injectors.get(moduleClassName);
        if (injector == null) {
            injector = Guice.createInjector((Module[])new Module[]{module});
            injectors.put(moduleClassName, injector);
        }
        return injector;
    }
}

