/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.ArrayList;
import java.util.List;

public class CastMember {
    private final String name;
    private String description;
    private final List<String> can;
    private final List<String> has;

    public CastMember(String name) {
        this(name, new ArrayList<String>(), new ArrayList<String>());
    }

    public CastMember(String name, List<String> can, List<String> has) {
        this.name = name;
        this.can = can;
        this.has = has;
    }

    public CastMember addAbility(String ability) {
        if (!this.can.contains(ability)) {
            this.can.add(ability);
        }
        return this;
    }

    public CastMember addFact(String fact) {
        if (!this.has.contains(fact)) {
            this.has.add(fact);
        }
        return this;
    }

    public CastMember withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCan() {
        return this.can;
    }

    public Boolean hasFacts() {
        return this.has != null && !this.has.isEmpty();
    }

    public Boolean hasAbilities() {
        return this.can != null && !this.can.isEmpty();
    }

    public List<String> getHas() {
        return this.has;
    }

    public String getDescription() {
        return this.description;
    }
}

