/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.serenitybdd.core.collect.NewSet;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.CoreTagProvider;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class ContextTagProvider
implements TagProvider,
CoreTagProvider {
    EnvironmentVariables environmentVariables;

    public ContextTagProvider() {
        this((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public ContextTagProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        if (StringUtils.isEmpty((CharSequence)testOutcome.getContext())) {
            return new HashSet<TestTag>();
        }
        if (!ThucydidesSystemProperty.THUCYDIDES_ADD_CONTEXT_TAG.booleanFrom(this.environmentVariables, true).booleanValue()) {
            return Collections.unmodifiableSet(new HashSet());
        }
        return NewSet.of(TestTag.withName(testOutcome.getContext()).andType("context"));
    }
}

