/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.tags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;

public class BreadcrumbTagFilter {
    private final RequirementsService requirementsService;

    public BreadcrumbTagFilter(RequirementsService requirementsService) {
        this.requirementsService = requirementsService;
    }

    public BreadcrumbTagFilter() {
        this((RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    public boolean isRequirementTag(TestTag tag) {
        return this.requirementsService.isRequirementsTag(tag);
    }

    public List<TestTag> getRequirementBreadcrumbsFrom(Collection<TestTag> tags) {
        ArrayList<TestTag> requirementTypeTags = new ArrayList<TestTag>();
        for (String requirementType : this.requirementsService.getRequirementTypes()) {
            this.requirementTagOfType(requirementType).in(tags).ifPresent(requirementTypeTags::add);
        }
        return requirementTypeTags;
    }

    public List<TestTag> getRequirementBreadcrumbsFrom(TestTag tag) {
        ArrayList requirementTypeTags = new ArrayList();
        Optional<Requirement> displayedRequirement = this.requirementsService.getRequirementFor(tag);
        return displayedRequirement.isPresent() ? NewList.of(displayedRequirement.get().asTag()) : NewList.of(new TestTag[0]);
    }

    public List<TestTag> getRequirementBreadcrumbsFrom(TestOutcome testOutcome) {
        List<Requirement> ancestors = this.requirementsService.getAncestorRequirementsFor(testOutcome);
        if (ancestors == null) {
            return new ArrayList<TestTag>();
        }
        return ancestors.stream().map(Requirement::asTag).collect(Collectors.toList());
    }

    private RequirementTagFilter requirementTagOfType(String requirementType) {
        return new RequirementTagFilter(requirementType);
    }

    public List<TestTag> getRequirementBreadcrumbsFrom(RequirementsOutcomes requirementsOutcomes) {
        ArrayList<TestTag> breadcrumbs = new ArrayList<TestTag>();
        if (requirementsOutcomes.getParentRequirement().isPresent()) {
            breadcrumbs.add(requirementsOutcomes.getParentRequirement().get().asTag());
        }
        return breadcrumbs;
    }

    public static class RequirementTagFilter {
        private String requirementType;

        public RequirementTagFilter(String requirementType) {
            this.requirementType = requirementType;
        }

        public Optional<TestTag> in(Collection<TestTag> tags) {
            for (TestTag tag : tags) {
                if (!tag.getType().equals(this.requirementType)) continue;
                return Optional.of(tag);
            }
            return Optional.empty();
        }
    }
}

