/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.tags;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.core.tags.EnvironmentDefinedTags;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.reports.ScenarioOutcome;
import net.thucydides.core.util.EnvironmentVariables;

public class OutcomeTagFilter {
    private final EnvironmentVariables environmentVariables;
    private final List<TestTag> tags;

    public OutcomeTagFilter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.tags = EnvironmentDefinedTags.definedIn(environmentVariables);
    }

    public List<ScenarioOutcome> scenariosFilteredByTagIn(List<ScenarioOutcome> testOutcomes) {
        if (this.tags.isEmpty()) {
            return testOutcomes;
        }
        return testOutcomes.stream().filter(scenarioOutcome -> this.hasMatchingTags(scenarioOutcome.getTags(), this.tags)).collect(Collectors.toList());
    }

    public List<? extends TestOutcome> outcomesFilteredByTagIn(List<? extends TestOutcome> testOutcomes) {
        if (this.tags.isEmpty()) {
            return testOutcomes;
        }
        return testOutcomes.stream().filter(outcome -> this.hasMatchingTags(outcome.getTags(), this.tags)).collect(Collectors.toList());
    }

    private boolean hasMatchingTags(Set<TestTag> outcomeTags, List<TestTag> filteredTags) {
        return outcomeTags.stream().anyMatch(filteredTags::contains);
    }
}

