/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.configuration;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.configuration.TimeoutValue;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class TimeoutConfiguration {
    public static TimeoutConfigurationGetter from(EnvironmentVariables environmentVariables) {
        return new TimeoutConfigurationGetter(environmentVariables);
    }

    public static class TimeoutConfigurationGetter {
        private final EnvironmentVariables environmentVariables;

        public TimeoutConfigurationGetter(EnvironmentVariables environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        public TimeoutValue forProperty(String configurationProperty, TimeoutValue defaultTimeout) {
            String timeout = EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalProperty(configurationProperty).orElse(null);
            if (StringUtils.isEmpty((CharSequence)timeout)) {
                return defaultTimeout;
            }
            List timeoutElements = Splitter.on((String)" ").splitToList((CharSequence)timeout);
            long numericalValue = Long.parseLong((String)timeoutElements.get(0));
            TimeUnit timeoutUnits = timeoutElements.size() > 1 ? TimeUnit.valueOf(((String)timeoutElements.get(1)).toUpperCase()) : TimeUnit.SECONDS;
            return new TimeoutValue(numericalValue, timeoutUnits);
        }
    }
}

