/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementTree;

public class RequirementsTree {
    private final List<Requirement> rootRequirements;

    private RequirementsTree(Requirement root) {
        this.rootRequirements = Collections.singletonList(root);
    }

    private RequirementsTree(List<Requirement> requirements) {
        this.rootRequirements = requirements;
    }

    public static RequirementsTree forRequirement(Requirement root) {
        return new RequirementsTree(root);
    }

    public static RequirementsTree from(List<Requirement> requirements) {
        return new RequirementsTree(requirements);
    }

    public Stream<Requirement> stream() {
        return this.rootRequirements.stream().flatMap(Requirement::stream);
    }

    public List<Requirement> asFlattenedList() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        this.rootRequirements.forEach(requirement -> {
            requirements.add((Requirement)requirement);
            for (Requirement child : requirement.getChildren()) {
                requirements.addAll(RequirementsTree.forRequirement(child).asFlattenedList());
            }
        });
        return requirements;
    }

    public String toString() {
        return RequirementTree.withRequirements(this.rootRequirements).toString();
    }
}

