/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.annotations.TestsRequirement;
import net.thucydides.core.annotations.TestsRequirements;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.reflection.MethodFinder;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.MetaField;
import net.thucydides.core.steps.ReplaceField;
import net.thucydides.core.steps.ScreenplayInspector;
import net.thucydides.core.steps.TestStatus;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public final class AnnotatedStepDescription {
    private static final List<String> VALID_STEP_ANNOTATIONS = NewList.of("Step", "Given", "When", "Then");
    private final ExecutedStepDescription description;

    public static AnnotatedStepDescription from(ExecutedStepDescription description) {
        return new AnnotatedStepDescription(description);
    }

    private AnnotatedStepDescription(ExecutedStepDescription description) {
        this.description = description;
    }

    public List<String> getAnnotatedRequirements() {
        ArrayList<String> requirements = new ArrayList<String>();
        Method testMethod = this.getTestMethod();
        if (testMethod != null) {
            this.addRequirementFrom(requirements, testMethod);
            this.addMultipleRequirementsFrom(requirements, testMethod);
        }
        return requirements;
    }

    private void addMultipleRequirementsFrom(List<String> requirements, Method testMethod) {
        TestsRequirements testRequirements = testMethod.getAnnotation(TestsRequirements.class);
        if (testRequirements != null) {
            requirements.addAll(Arrays.asList(testRequirements.value()));
        }
    }

    private void addRequirementFrom(List<String> requirements, Method testMethod) {
        TestsRequirement testsRequirement = testMethod.getAnnotation(TestsRequirement.class);
        if (testsRequirement != null) {
            requirements.add(testsRequirement.value());
        }
    }

    public Method getTestMethod() {
        if (this.getTestClass() != null) {
            if (ScreenplayInspector.isAScreenplayClass(this.getTestClass())) {
                return ScreenplayInspector.performAsMethodIn(this.getTestClass());
            }
            return this.methodCalled(this.description, this.getTestClass());
        }
        return null;
    }

    public Method getTestMethodIfPresent() {
        return this.findMethodCalled(this.description, this.getTestClass());
    }

    private String withNoArguments(String methodName) {
        String unqualifiedName = this.unqualified(methodName);
        return this.stripFrom(':', unqualifiedName);
    }

    private String stripFrom(char boundaryChar, String text) {
        int boundaryPosition = text.indexOf(boundaryChar);
        if (boundaryPosition > 0) {
            return text.substring(0, boundaryPosition);
        }
        return text;
    }

    private String unqualified(String methodName) {
        return StringUtils.stripStart((String)methodName, (String)"[0123456789] ");
    }

    private Class<?> getTestClass() {
        return this.description.getStepClass();
    }

    private Method methodCalled(ExecutedStepDescription methodName, Class<?> testClass) {
        Method methodFound = this.findMethodCalled(methodName, testClass);
        if (methodFound == null) {
            throw new IllegalArgumentException("No test method called " + methodName + " was found in " + testClass);
        }
        return methodFound;
    }

    private Method findMethodCalled(ExecutedStepDescription method, Class<?> testClass) {
        return MethodFinder.inClass(testClass).getMethodNamed(this.withNoArguments(method.getName()), method.getArguments().size());
    }

    public String getAnnotatedTitle() {
        Method testMethod = this.getTestMethod();
        Title title = testMethod.getAnnotation(Title.class);
        if (title != null) {
            return title.value();
        }
        return null;
    }

    private Optional<String> getAnnotatedStepName() {
        Optional<String> stepAnnotatedName = this.getNameFromStepAnnotationIn(this.getTestMethod());
        if (stepAnnotatedName.isPresent()) {
            return stepAnnotatedName;
        }
        return this.getCompatibleStepNameFrom(this.getTestMethod());
    }

    public static boolean isACompatibleStep(Annotation annotation) {
        return VALID_STEP_ANNOTATIONS.contains(annotation.annotationType().getSimpleName());
    }

    private Optional<String> getCompatibleStepNameFrom(Method testMethod) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = testMethod.getAnnotations()) {
            if (!AnnotatedStepDescription.isACompatibleStep(annotation)) continue;
            try {
                String annotationType = annotation.annotationType().getSimpleName();
                String annotatedValue = (String)annotation.getClass().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                if (StringUtils.isEmpty((CharSequence)annotatedValue)) {
                    return Optional.empty();
                }
                return Optional.of(annotationType + " " + StringUtils.uncapitalize((String)annotatedValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private Optional<String> getNameFromStepAnnotationIn(Method testMethod) {
        Step step = testMethod.getAnnotation(Step.class);
        if (step != null && !StringUtils.isEmpty((CharSequence)step.value())) {
            return Optional.of(this.injectAnnotatedFieldValuesFrom(this.description).into(step.value()));
        }
        return Optional.empty();
    }

    private AnnotatedFieldValuesBuilder injectAnnotatedFieldValuesFrom(ExecutedStepDescription description) {
        return new AnnotatedFieldValuesBuilder(description);
    }

    public String getName() {
        if (this.noClassIsDefined()) {
            return this.description.getName();
        }
        if (this.isAGroup()) {
            return this.groupName();
        }
        return this.stepName();
    }

    private boolean noClassIsDefined() {
        return this.description.getStepClass() == null;
    }

    private String groupName() {
        String annotatedGroupName = this.getGroupName();
        if (!StringUtils.isEmpty((CharSequence)annotatedGroupName)) {
            return annotatedGroupName;
        }
        return this.stepName();
    }

    private String stepName() {
        String annotationTitle = this.getAnnotatedTitle();
        if (!StringUtils.isEmpty((CharSequence)annotationTitle)) {
            return annotationTitle;
        }
        Optional<String> annotatedStepName = this.getAnnotatedStepName();
        if (this.getAnnotatedStepName().isPresent() && StringUtils.isNotEmpty((CharSequence)annotatedStepName.get())) {
            return this.annotatedStepNameWithParameters(annotatedStepName.get());
        }
        return NameConverter.humanize(this.description.getName());
    }

    private String annotatedStepNameWithParameters(String annotatedStepTemplate) {
        String annotatedStepName = annotatedStepTemplate;
        for (int i = 0; i < this.description.getRawArguments().size(); ++i) {
            Pattern tokenPattern = Pattern.compile(String.format("\\{%d(\\.[^}]+)?\\}", i));
            Matcher tokenMatcher = tokenPattern.matcher(annotatedStepName);
            ArrayList<String> tokens = new ArrayList<String>();
            ArrayList<String> tokenDetails = new ArrayList<String>();
            while (tokenMatcher.find()) {
                String token = tokenMatcher.group();
                if (tokens.contains(token)) continue;
                tokens.add(token);
                String tokenDetail = tokenMatcher.group(1);
                tokenDetails.add(tokenDetail);
            }
            Object argument = this.description.getRawArguments().get(i);
            for (int j = 0; j < tokens.size(); ++j) {
                String replacement = tokenDetails.get(j) != null ? this.getReplacementForArgument(argument, (String)tokenDetails.get(j)) : this.description.getArguments().get(i);
                annotatedStepName = StringUtils.replace((String)annotatedStepName, (String)((String)tokens.get(j)), (String)replacement);
            }
        }
        return annotatedStepName;
    }

    private String getReplacementForArgument(Object argument, String tokenDetail) {
        List references = Stream.of(tokenDetail.split("\\.")).filter(e -> !e.isEmpty()).map(String::trim).collect(Collectors.toList());
        Object resolvedObject = argument;
        for (String reference : references) {
            boolean isMethod = this.isMethod(reference);
            if (isMethod) {
                resolvedObject = this.getMethodResult(resolvedObject, reference);
                continue;
            }
            resolvedObject = this.getFieldValue(resolvedObject, reference);
        }
        return String.valueOf(resolvedObject);
    }

    private Object getMethodResult(Object o, String methodName) {
        if (o == null) {
            return null;
        }
        String cleanedMethodName = methodName.replace("()", "").trim();
        try {
            return MethodUtils.invokeMethod((Object)o, (String)cleanedMethodName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return String.valueOf(o);
        }
    }

    private Object getFieldValue(Object o, String fieldName) {
        if (o == null) {
            return null;
        }
        try {
            return FieldUtils.readField((Object)o, (String)fieldName, (boolean)true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return String.valueOf(o);
        }
    }

    private boolean isMethod(String reference) {
        return reference.endsWith("()");
    }

    public boolean isAGroup() {
        Method testMethod = this.getTestMethodIfPresent();
        if (testMethod != null) {
            StepGroup testGroup = testMethod.getAnnotation(StepGroup.class);
            return testGroup != null;
        }
        return false;
    }

    private String getGroupName() {
        Method testMethod = this.getTestMethodIfPresent();
        StepGroup testGroup = testMethod.getAnnotation(StepGroup.class);
        return testGroup.value();
    }

    public boolean isPending() {
        Method testMethod = this.getTestMethodIfPresent();
        return testMethod != null && TestStatus.of(testMethod).isPending();
    }

    public boolean isIgnored() {
        Method testMethod = this.getTestMethodIfPresent();
        return testMethod != null && TestStatus.of(testMethod).isIgnored();
    }

    private class AnnotatedFieldValuesBuilder {
        private final ExecutedStepDescription description;

        private AnnotatedFieldValuesBuilder(ExecutedStepDescription description) {
            this.description = description;
        }

        public String into(String stepDescription) {
            stepDescription = this.resolveMetaFieldIfPresentIn(stepDescription);
            Map<String, Object> fields = this.description.getDisplayedFields();
            for (String field : fields.keySet()) {
                stepDescription = ReplaceField.in(stepDescription).theFieldCalled(field).with(fields.get(field));
            }
            return stepDescription;
        }

        private String resolveMetaFieldIfPresentIn(String stepDescription) {
            if (!MetaField.from(stepDescription).isDefined()) {
                return stepDescription;
            }
            String metafield = MetaField.from(stepDescription).template();
            String metafieldName = MetaField.from(stepDescription).fieldName();
            Optional<String> matchingField = this.description.getDisplayedFields().keySet().stream().filter(key -> key.equals(metafieldName)).findFirst();
            HashMap<String, Object> displayedFields = new HashMap<String, Object>(this.description.getDisplayedFields());
            if (matchingField.isPresent()) {
                String field = matchingField.get();
                stepDescription = ReplaceField.in(metafield).theFieldCalled(field).with(displayedFields.get(field));
                displayedFields.remove(field);
            }
            return stepDescription;
        }
    }
}

