/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.RequirementsOverviewReportingTask;
import net.thucydides.core.reports.html.RequirementsTypeReportingTask;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsOutcomeFactory;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.EnvironmentVariables;

public class RequirementsReports {
    private ReportNameProvider reportNameProvider;
    private RequirementsOutcomeFactory requirementsFactory;
    private ReleaseManager releaseManager;
    private final String relativeLink;
    private final RequirementsService requirementsService;
    private final RequirementsConfiguration requirementsConfiguration;
    private final TestOutcomes testOutcomes;
    final FreemarkerContext freemarker;
    final EnvironmentVariables environmentVariables;
    final File outputDirectory;

    public RequirementsReports(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsOutcomeFactory requirementsFactory, RequirementsService requirementsService, String relativeLink, TestOutcomes testOutcomes) {
        this.freemarker = freemarker;
        this.environmentVariables = environmentVariables;
        this.outputDirectory = outputDirectory;
        this.reportNameProvider = reportNameProvider;
        this.requirementsFactory = requirementsFactory;
        this.requirementsService = requirementsService;
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        this.testOutcomes = testOutcomes;
        this.relativeLink = relativeLink;
    }

    public static Set<ReportingTask> requirementsReportsFor(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsOutcomeFactory requirementsFactory, RequirementsService requirementsService, String relativeLink, TestOutcomes testOutcomes, RequirementsOutcomes requirementsOutcomes) throws IOException {
        HashSet<ReportingTask> reportingTasks = new HashSet<ReportingTask>();
        RequirementsReports reporter = new RequirementsReports(freemarker, environmentVariables, outputDirectory, reportNameProvider, requirementsFactory, requirementsService, relativeLink, testOutcomes);
        reportingTasks.addAll(RequirementsTypeReportingTask.requirementTypeReports(requirementsService.getRequirementTypes(), requirementsOutcomes, freemarker, environmentVariables, outputDirectory, reportNameProvider));
        reportingTasks.add(new RequirementsOverviewReportingTask(freemarker, environmentVariables, outputDirectory, reportNameProvider, requirementsService, requirementsOutcomes.withoutUnrelatedRequirements(), relativeLink, testOutcomes).asParentRequirement());
        reportingTasks.addAll(reporter.reportsForChildRequirements(requirementsOutcomes));
        return reportingTasks;
    }

    private List<ReportingTask> reportsForChildRequirements(RequirementsOutcomes requirementsOutcomes) throws IOException {
        ArrayList<ReportingTask> reportingTasks = new ArrayList<ReportingTask>();
        for (RequirementOutcome outcome : requirementsOutcomes.getRequirementOutcomes()) {
            Requirement requirement = outcome.getRequirement();
            TestOutcomes testOutcomesForThisRequirement = outcome.getTestOutcomes().forRequirement(requirement);
            RequirementsOutcomes requirementOutcomesForThisRequirement = this.requirementsFactory.buildRequirementsOutcomesFrom(requirement, testOutcomesForThisRequirement).withoutUnrelatedRequirements();
            reportingTasks.addAll(this.nestedRequirementsReportsFor(requirement, requirementOutcomesForThisRequirement));
        }
        return reportingTasks;
    }

    private List<ReportingTask> nestedRequirementsReportsFor(Requirement parentRequirement, RequirementsOutcomes requirementsOutcomes) throws IOException {
        ArrayList<ReportingTask> reportingTasks = new ArrayList<ReportingTask>();
        String reportName = this.reportNameProvider.forRequirement(parentRequirement);
        reportingTasks.add(new RequirementsOverviewReportingTask(this.freemarker, this.environmentVariables, this.outputDirectory, this.reportNameProvider, this.requirementsService, requirementsOutcomes, this.relativeLink, requirementsOutcomes.getTestOutcomes(), reportName).asLeafRequirement());
        reportingTasks.addAll(this.requirementsReportsForChildRequirements(requirementsOutcomes));
        return reportingTasks;
    }

    private List<ReportingTask> requirementsReportsForChildRequirements(RequirementsOutcomes requirementsOutcomes) throws IOException {
        ArrayList<ReportingTask> reportingTasks = new ArrayList<ReportingTask>();
        List requirementOutcomes = requirementsOutcomes.getRequirementOutcomes();
        for (RequirementOutcome outcome : requirementOutcomes) {
            Requirement requirement = outcome.getRequirement();
            TestOutcomes testOutcomesForThisRequirement = outcome.getTestOutcomes().forRequirement(requirement);
            RequirementsOutcomes requirementOutcomesForThisRequirement = this.requirementsFactory.buildRequirementsOutcomesFrom(requirement, testOutcomesForThisRequirement);
            reportingTasks.addAll(this.nestedRequirementsReportsFor(requirement, requirementOutcomesForThisRequirement));
        }
        return reportingTasks;
    }

    public List<String> getRequirementTypes() {
        List types = this.requirementsService.getRequirementTypes();
        if (types.isEmpty()) {
            return this.requirementsConfiguration.getRequirementTypes();
        }
        return types;
    }
}

