/*
 * Decompiled with CFR 0.152.
 */
package emulib.emustudio;

import emulib.emustudio.debugtable.DebugTable;
import emulib.runtime.exceptions.InvalidPasswordException;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class API {
    private static final AtomicReference<String> EMUSTUDIO_PASSWORD = new AtomicReference();
    private static final API INSTANCE = new API();
    private final AtomicReference<DebugTable> debugTable = new AtomicReference();

    private API() {
    }

    public static API getInstance() {
        return INSTANCE;
    }

    public synchronized void clearAll(String password) throws InvalidPasswordException {
        API.testPassword(password);
        this.debugTable.set(null);
    }

    public static boolean assignPassword(String password) {
        return EMUSTUDIO_PASSWORD.compareAndSet(null, password);
    }

    public static void testPassword(String password) throws InvalidPasswordException {
        String tmpPassword = EMUSTUDIO_PASSWORD.get();
        if (password == null || tmpPassword == null) {
            throw new InvalidPasswordException();
        }
        if (!password.equals(tmpPassword)) {
            throw new InvalidPasswordException();
        }
    }

    public static boolean testPassword(Long hashCode) {
        String tmpPassword = EMUSTUDIO_PASSWORD.get();
        return hashCode != null && tmpPassword != null && hashCode == (long)tmpPassword.hashCode();
    }

    public void setDebugTable(DebugTable debugTable, String password) throws InvalidPasswordException {
        API.testPassword(password);
        this.debugTable.set(debugTable);
    }

    public DebugTable getDebugTable() {
        return this.debugTable.get();
    }
}

