/*
 * Decompiled with CFR 0.152.
 */
package emulib.emustudio.debugtable;

import emulib.plugins.cpu.AbstractDebugColumn;
import emulib.plugins.cpu.CPU;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreakpointColumn
extends AbstractDebugColumn {
    private static final Logger LOGGER = LoggerFactory.getLogger(BreakpointColumn.class);
    private final CPU cpu;

    public BreakpointColumn(CPU cpu) {
        super("bp", Boolean.class, true);
        this.cpu = Objects.requireNonNull(cpu);
    }

    @Override
    public void setDebugValue(int location, Object value) {
        if (this.cpu.isBreakpointSupported()) {
            boolean shouldSet = Boolean.valueOf(value.toString());
            try {
                if (shouldSet) {
                    this.cpu.setBreakpoint(location);
                } else {
                    this.cpu.unsetBreakpoint(location);
                }
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.error("Could not " + (shouldSet ? "set" : "unset") + " breakpoint to address {}", (Object)String.format("%04xh", location), (Object)e);
            }
        }
    }

    @Override
    public Object getDebugValue(int location) {
        if (!this.cpu.isBreakpointSupported()) {
            return false;
        }
        try {
            return this.cpu.isBreakpointSet(location);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public boolean isEditable() {
        return this.cpu.isBreakpointSupported();
    }

    @Override
    public int getDefaultWidth() {
        return 20;
    }
}

