/*
 * Decompiled with CFR 0.152.
 */
package emulib.plugins.cpu;

import emulib.annotations.PluginType;
import emulib.plugins.cpu.CPU;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractCPU
implements CPU,
Callable<CPU.RunState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCPU.class);
    private static final Runnable EMPTY_TASK = () -> {};
    private final AtomicBoolean isDestroyed = new AtomicBoolean();
    private final ExecutorService eventReceiver = Executors.newSingleThreadExecutor();
    private final ExecutorService cpuExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService cpuStoppedWatcher = Executors.newSingleThreadExecutor();
    private final long pluginID;
    private final Set<CPU.CPUListener> stateObservers = new CopyOnWriteArraySet<CPU.CPUListener>();
    private final Set<Integer> breakpoints = new ConcurrentSkipListSet<Integer>();
    private volatile CPU.RunState runState = CPU.RunState.STATE_STOPPED_NORMAL;
    private volatile CPUWatchTask cpuWatchTask;

    public AbstractCPU(Long pluginID) {
        this.pluginID = Objects.requireNonNull(pluginID);
    }

    protected long getPluginID() {
        return this.pluginID;
    }

    @Override
    public String getTitle() {
        return this.getClass().getAnnotation(PluginType.class).title();
    }

    @Override
    public void showSettings() {
    }

    @Override
    public boolean isShowSettingsSupported() {
        return false;
    }

    @Override
    public boolean isBreakpointSupported() {
        return true;
    }

    @Override
    public void setBreakpoint(int memLocation) {
        this.breakpoints.add(memLocation);
    }

    @Override
    public void unsetBreakpoint(int memLocation) {
        this.breakpoints.remove(memLocation);
    }

    @Override
    public boolean isBreakpointSet(int memLocation) {
        return this.breakpoints.contains(memLocation);
    }

    @Override
    public boolean addCPUListener(CPU.CPUListener listener) {
        return this.stateObservers.add(listener);
    }

    @Override
    public boolean removeCPUListener(CPU.CPUListener listener) {
        return this.stateObservers.remove(listener);
    }

    private void stopExecutor(ExecutorService executor) {
        Objects.requireNonNull(executor);
        executor.shutdown();
        try {
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void destroy() {
        if (this.isDestroyed.compareAndSet(false, true)) {
            try {
                this.stop();
                this.stopExecutor(this.eventReceiver);
                this.stopExecutor(this.cpuExecutor);
                this.stopExecutor(this.cpuStoppedWatcher);
                this.stateObservers.clear();
            }
            finally {
                this.destroyInternal();
            }
        }
    }

    protected abstract void destroyInternal();

    private void waitForFuture(Future future) {
        Objects.requireNonNull(future);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
    }

    private void notifyStateChanged() {
        CPU.RunState tmpRunState = this.runState;
        this.stateObservers.forEach(observer -> {
            try {
                observer.runStateChanged(tmpRunState);
                observer.internalStateChanged();
            }
            catch (Exception e) {
                LOGGER.error("CPU Listener error", (Throwable)e);
            }
        });
    }

    private void ensureCpuIsStopped() {
        try {
            this.cpuStoppedWatcher.submit(EMPTY_TASK).get();
        }
        catch (ExecutionException e) {
            LOGGER.error("Unexpected error while waiting for CPU stop", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void reset() {
        this.reset(0);
    }

    @Override
    public void reset(int addr) {
        Future<?> future = this.eventReceiver.submit(() -> {
            this.requestStop();
            this.ensureCpuIsStopped();
            this.resetInternal(addr);
            this.runState = CPU.RunState.STATE_STOPPED_BREAK;
            this.notifyStateChanged();
        });
        this.waitForFuture(future);
    }

    @Override
    public void execute() {
        Future<?> future = this.eventReceiver.submit(() -> {
            if (this.runState == CPU.RunState.STATE_STOPPED_BREAK) {
                this.runState = CPU.RunState.STATE_RUNNING;
                this.notifyStateChanged();
                Future<CPU.RunState> cpuFuture = this.cpuExecutor.submit(this);
                this.cpuWatchTask = new CPUWatchTask(cpuFuture);
                this.cpuStoppedWatcher.submit(this.cpuWatchTask);
            }
        });
        this.waitForFuture(future);
    }

    @Override
    public void pause() {
        Future<?> future = this.eventReceiver.submit(() -> {
            if (this.runState == CPU.RunState.STATE_RUNNING) {
                this.requestStop();
                this.ensureCpuIsStopped();
                if (this.runState == CPU.RunState.STATE_RUNNING || this.runState == CPU.RunState.STATE_STOPPED_NORMAL) {
                    this.runState = CPU.RunState.STATE_STOPPED_BREAK;
                }
                this.notifyStateChanged();
            }
        });
        this.waitForFuture(future);
    }

    @Override
    public void stop() {
        Future<?> future = this.eventReceiver.submit(() -> {
            if (this.runState == CPU.RunState.STATE_STOPPED_BREAK || this.runState == CPU.RunState.STATE_RUNNING) {
                this.requestStop();
                this.ensureCpuIsStopped();
                if (this.runState == CPU.RunState.STATE_RUNNING || this.runState == CPU.RunState.STATE_STOPPED_BREAK) {
                    this.runState = CPU.RunState.STATE_STOPPED_NORMAL;
                }
                this.notifyStateChanged();
            }
        });
        this.waitForFuture(future);
    }

    @Override
    public void step() {
        Future<?> future = this.eventReceiver.submit(() -> {
            if (this.runState == CPU.RunState.STATE_STOPPED_BREAK) {
                try {
                    this.runState = this.stepInternal();
                    if (this.runState == CPU.RunState.STATE_RUNNING) {
                        this.runState = CPU.RunState.STATE_STOPPED_BREAK;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    this.runState = CPU.RunState.STATE_STOPPED_ADDR_FALLOUT;
                    LOGGER.error("Unexpected error during emulation", (Throwable)e);
                }
                catch (Exception e) {
                    this.runState = e.getCause() != null && e.getCause() instanceof IndexOutOfBoundsException ? CPU.RunState.STATE_STOPPED_ADDR_FALLOUT : CPU.RunState.STATE_STOPPED_BAD_INSTR;
                    LOGGER.error("Unexpected error during emulation", (Throwable)e);
                }
                this.notifyStateChanged();
            }
        });
        this.waitForFuture(future);
    }

    private void requestStop() {
        CPUWatchTask tmpCpuWatchTask = this.cpuWatchTask;
        if (tmpCpuWatchTask != null) {
            tmpCpuWatchTask.requestStop();
        }
    }

    protected abstract CPU.RunState stepInternal() throws Exception;

    protected abstract void resetInternal(int var1);

    private class CPUWatchTask
    implements Runnable {
        private final Future<CPU.RunState> cpuFuture;

        private CPUWatchTask(Future<CPU.RunState> cpuFuture) {
            this.cpuFuture = Objects.requireNonNull(cpuFuture);
        }

        @Override
        public void run() {
            try {
                AbstractCPU.this.runState = this.cpuFuture.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IndexOutOfBoundsException) {
                    AbstractCPU.this.runState = CPU.RunState.STATE_STOPPED_ADDR_FALLOUT;
                } else {
                    Throwable cause = e.getCause().getCause();
                    if (cause != null && cause instanceof IndexOutOfBoundsException) {
                        AbstractCPU.this.runState = CPU.RunState.STATE_STOPPED_ADDR_FALLOUT;
                    } else {
                        AbstractCPU.this.runState = CPU.RunState.STATE_STOPPED_BAD_INSTR;
                    }
                }
                LOGGER.error("Unexpected error during emulation", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                AbstractCPU.this.notifyStateChanged();
            }
        }

        void requestStop() {
            this.cpuFuture.cancel(true);
        }
    }
}

