/*
 * Decompiled with CFR 0.152.
 */
package emulib.plugins.cpu;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DecodedInstruction {
    private final Map<Integer, Integer> constants = new TreeMap<Integer, Integer>();
    private final Map<Integer, String> strings = new TreeMap<Integer, String>();
    private final Map<Integer, byte[]> bits = new TreeMap<Integer, byte[]>();
    private byte[] image;

    public void add(int key, String string, int constant) {
        this.constants.put(key, constant);
        this.strings.put(key, string);
    }

    public void add(int key, byte[] bits) {
        this.bits.put(key, bits);
    }

    public boolean hasKey(int key) {
        return this.bits.containsKey(key) || this.constants.containsKey(key);
    }

    public int get(int key) {
        Integer value = this.constants.get(key);
        return value != null ? value : -1;
    }

    public String getString(int key) {
        return this.strings.get(key);
    }

    public byte[] getBits(int key) {
        return this.bits.get(key);
    }

    public byte[] getBits(int key, boolean reverseBytes) {
        byte[] data = this.bits.get(key);
        if (reverseBytes && data != null) {
            return this.reverseBytes(data);
        }
        return data;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public int getLength() {
        return this.image.length;
    }

    public Set<Integer> getKeys() {
        HashSet<Integer> keys = new HashSet<Integer>(this.constants.keySet());
        keys.addAll(this.bits.keySet());
        return keys;
    }

    private byte[] reverseBytes(byte[] data) {
        byte[] result = new byte[data.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data[data.length - i - 1];
        }
        return result;
    }
}

