/*
 * Decompiled with CFR 0.152.
 */
package emulib.plugins.memory;

import emulib.plugins.memory.Memory;
import emulib.plugins.memory.MemoryContext;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractMemoryContext<Type>
implements MemoryContext<Type> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMemoryContext.class);
    private volatile boolean notificationsEnabled = true;
    protected final Set<Memory.MemoryListener> listeners = new CopyOnWriteArraySet<Memory.MemoryListener>();

    @Override
    public boolean areMemoryNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    @Override
    public void setMemoryNotificationsEnabled(boolean enabled) {
        this.notificationsEnabled = enabled;
    }

    @Override
    public void addMemoryListener(Memory.MemoryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeMemoryListener(Memory.MemoryListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyMemoryChanged(int position) {
        if (this.notificationsEnabled) {
            this.listeners.forEach(listener -> {
                try {
                    listener.memoryChanged(position);
                }
                catch (Exception e) {
                    LOGGER.error("Memory listener error", (Throwable)e);
                }
            });
        }
    }

    public void notifyMemorySizeChanged() {
        if (this.notificationsEnabled) {
            this.listeners.forEach(listener -> {
                try {
                    listener.memorySizeChanged();
                }
                catch (Exception e) {
                    LOGGER.error("Memory listener error", (Throwable)e);
                }
            });
        }
    }
}

