/*
 * Decompiled with CFR 0.152.
 */
package emulib.runtime;

import emulib.annotations.ContextType;
import emulib.emustudio.API;
import emulib.plugins.Context;
import emulib.plugins.compiler.CompilerContext;
import emulib.plugins.cpu.CPUContext;
import emulib.plugins.device.DeviceContext;
import emulib.plugins.memory.MemoryContext;
import emulib.runtime.PluginLoader;
import emulib.runtime.RadixUtils;
import emulib.runtime.exceptions.AlreadyRegisteredException;
import emulib.runtime.exceptions.ContextNotFoundException;
import emulib.runtime.exceptions.InvalidContextException;
import emulib.runtime.exceptions.InvalidPasswordException;
import emulib.runtime.interfaces.PluginConnections;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextPool.class);
    private final Map<String, List<Context>> allContexts = new HashMap<String, List<Context>>();
    private final Map<Long, List<Context>> contextOwners = new HashMap<Long, List<Context>>();
    private final AtomicReference<PluginConnections> computer = new AtomicReference();
    private final ReadWriteLock registeringLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(long pluginID, Context context, Class<? extends Context> contextInterface) throws AlreadyRegisteredException, InvalidContextException {
        this.trustedContext(contextInterface);
        String contextHash = ContextPool.computeHash(contextInterface);
        if (!PluginLoader.doesImplement(context.getClass(), contextInterface)) {
            throw new InvalidContextException("Context does not implement context interface");
        }
        this.registeringLock.writeLock().lock();
        try {
            List<Context> contextsByHash = this.allContexts.get(contextHash);
            if (contextsByHash != null && contextsByHash.contains(context)) {
                throw new AlreadyRegisteredException();
            }
            List<Context> contextsByOwner = this.contextOwners.get(pluginID);
            if (contextsByOwner == null) {
                contextsByOwner = new ArrayList<Context>();
                this.contextOwners.put(pluginID, contextsByOwner);
            }
            contextsByOwner.add(context);
            if (contextsByHash == null) {
                contextsByHash = new ArrayList<Context>();
                this.allContexts.put(contextHash, contextsByHash);
            }
            contextsByHash.add(context);
        }
        finally {
            this.registeringLock.writeLock().unlock();
        }
    }

    private void trustedContext(Class<? extends Context> contextInterface) throws InvalidContextException {
        if (contextInterface == null) {
            throw new InvalidContextException("Interface is null");
        }
        if (!contextInterface.isInterface()) {
            throw new InvalidContextException("Given class is not interface");
        }
        if (!contextInterface.isAnnotationPresent(ContextType.class)) {
            throw new InvalidContextException("Interface is not annotated as context");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(long pluginID, Class<? extends Context> contextInterface) throws InvalidContextException {
        this.trustedContext(contextInterface);
        String contextHash = ContextPool.computeHash(contextInterface);
        this.registeringLock.writeLock().lock();
        try {
            List<Context> contextsByOwner = this.contextOwners.get(pluginID);
            if (contextsByOwner == null) {
                boolean bl = false;
                return bl;
            }
            List<Context> contextsByHash = this.allContexts.get(contextHash);
            if (contextsByHash == null) {
                boolean bl = false;
                return bl;
            }
            Iterator<Context> contextIterator = contextsByHash.iterator();
            while (contextIterator.hasNext()) {
                Context context = contextIterator.next();
                if (!contextsByOwner.contains(context)) continue;
                contextsByOwner.remove(context);
                contextIterator.remove();
            }
            if (contextsByHash.isEmpty()) {
                this.allContexts.remove(contextHash);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.registeringLock.writeLock().unlock();
        }
    }

    public boolean setComputer(String password, PluginConnections computer) throws InvalidPasswordException {
        API.testPassword(password);
        this.computer.set(computer);
        return true;
    }

    public void clearAll(String password) throws InvalidPasswordException {
        API.testPassword(password);
        this.computer.set(null);
        this.registeringLock.writeLock().lock();
        try {
            this.allContexts.clear();
            this.contextOwners.clear();
        }
        finally {
            this.registeringLock.writeLock().unlock();
        }
    }

    public <T extends Context> T getContext(long pluginID, Class<T> contextInterface, int index) throws InvalidContextException, ContextNotFoundException {
        this.trustedContext(contextInterface);
        this.registeringLock.readLock().lock();
        try {
            List<Context> contextsByHash = this.allContexts.get(ContextPool.computeHash(contextInterface));
            if (contextsByHash == null || contextsByHash.isEmpty()) {
                throw new ContextNotFoundException("Context " + contextInterface + " is not found in registered contexts list.");
            }
            LOGGER.debug("Matching context " + contextInterface + " from " + contextsByHash.size() + " options...");
            int j = 0;
            for (Context context : contextsByHash) {
                if (this.checkPermission(pluginID, context) && (index == -1 || j == index)) {
                    LOGGER.debug("Found context with index " + j);
                    Context context2 = context;
                    return (T)context2;
                }
                ++j;
            }
            throw new ContextNotFoundException("The plugin with ID " + pluginID + " has no permission to access context " + contextInterface);
        }
        finally {
            this.registeringLock.readLock().unlock();
        }
    }

    public <T extends CPUContext> T getCPUContext(long pluginID, Class<T> contextInterface) throws InvalidContextException, ContextNotFoundException {
        return (T)((CPUContext)this.getContext(pluginID, contextInterface, -1));
    }

    public <T extends CPUContext> T getCPUContext(long pluginID, Class<T> contextInterface, int index) throws InvalidContextException, ContextNotFoundException {
        return (T)((CPUContext)this.getContext(pluginID, contextInterface, index));
    }

    public <T extends CompilerContext> T getCompilerContext(long pluginID, Class<T> contextInterface) throws InvalidContextException, ContextNotFoundException {
        return (T)((CompilerContext)this.getContext(pluginID, contextInterface, -1));
    }

    public <T extends CompilerContext> T getCompilerContext(long pluginID, Class<T> contextInterface, int index) throws InvalidContextException, ContextNotFoundException {
        return (T)((CompilerContext)this.getContext(pluginID, contextInterface, index));
    }

    public <T extends MemoryContext> T getMemoryContext(long pluginID, Class<T> contextInterface) throws InvalidContextException, ContextNotFoundException {
        return (T)((MemoryContext)this.getContext(pluginID, contextInterface, -1));
    }

    public <T extends MemoryContext> T getMemoryContext(long pluginID, Class<T> contextInterface, int index) throws InvalidContextException, ContextNotFoundException {
        return (T)((MemoryContext)this.getContext(pluginID, contextInterface, index));
    }

    public <T extends DeviceContext> T getDeviceContext(long pluginID, Class<T> contextInterface) throws InvalidContextException, ContextNotFoundException {
        return (T)((DeviceContext)this.getContext(pluginID, contextInterface, -1));
    }

    public <T extends DeviceContext> T getDeviceContext(long pluginID, Class<T> contextInterface, int index) throws InvalidContextException, ContextNotFoundException {
        return (T)((DeviceContext)this.getContext(pluginID, contextInterface, index));
    }

    private Long findContextOwner(Context context) {
        Long contextOwner = null;
        for (Map.Entry<Long, List<Context>> owner : this.contextOwners.entrySet()) {
            List<Context> contextsByOwner = owner.getValue();
            assert (contextsByOwner != null);
            if (!contextsByOwner.contains(context)) continue;
            contextOwner = owner.getKey();
            break;
        }
        return contextOwner;
    }

    private boolean checkPermission(long pluginID, Context context) {
        if (API.testPassword(pluginID)) {
            return true;
        }
        PluginConnections tmpComputer = this.computer.get();
        if (tmpComputer == null) {
            LOGGER.debug("Plugin with ID=" + pluginID + " cannot have access to context " + context + ": Computer is not set.");
            return false;
        }
        Long contextOwner = this.findContextOwner(context);
        LOGGER.debug("Checking permission of plugin with ID=" + pluginID + " to context owner with ID=" + contextOwner + " (" + context + ")");
        return tmpComputer.isConnected(pluginID, contextOwner);
    }

    public static String computeHash(Class<? extends Context> contextInterface) {
        List<Method> contextMethods = Arrays.asList(contextInterface.getMethods());
        Collections.sort(contextMethods, (m1, m2) -> m1.getName().compareTo(m2.getName()));
        String hash = "";
        for (Method method : contextMethods.toArray(new Method[0])) {
            hash = hash + method.getGenericReturnType().toString() + " " + method.getName() + "(";
            for (Class<?> param : method.getParameterTypes()) {
                hash = hash + param.getName() + ",";
            }
            hash = hash + ");";
        }
        try {
            return ContextPool.SHA1(hash);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            LOGGER.error("Could not compute hash for interface " + contextInterface, (Throwable)e);
            return null;
        }
    }

    public static String SHA1(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(text.getBytes("iso-8859-1"), 0, text.length());
        byte[] sha1hash = md.digest();
        return RadixUtils.convertToRadix(sha1hash, 16, false);
    }
}

