/*
 * Decompiled with CFR 0.152.
 */
package emulib.runtime;

import emulib.emustudio.API;
import emulib.runtime.exceptions.InvalidPasswordException;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticDialogs {
    private static final String INPUT_DIALOG_MSG = "Please insert a value";
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticDialogs.class);
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private static boolean guiSupported = true;

    private StaticDialogs() {
    }

    private static String formatMessage(String title, String message) {
        return "[" + title + "] " + message;
    }

    public static void showErrorMessage(String message) {
        StaticDialogs.showErrorMessage(message, "Error");
    }

    public static void setGUISupported(boolean GUISupported, String password) throws InvalidPasswordException {
        API.testPassword(password);
        guiSupported = GUISupported;
    }

    public static boolean isGUISupported() {
        return guiSupported;
    }

    public static void showErrorMessage(String message, String title) {
        if (guiSupported) {
            JOptionPane.showMessageDialog(null, message, title, 0);
        } else {
            LOGGER.error(StaticDialogs.formatMessage(title, message));
        }
    }

    public static void showMessage(String message) {
        StaticDialogs.showMessage(message, "Information message");
    }

    public static void showMessage(String message, String title) {
        if (guiSupported) {
            JOptionPane.showMessageDialog(null, message, title, 1);
        } else {
            LOGGER.info(StaticDialogs.formatMessage(title, message));
        }
    }

    public static Integer inputIntValue(String message) {
        return StaticDialogs.inputIntValue(message, INPUT_DIALOG_MSG, 0);
    }

    public static Integer inputIntValue(String message, String title, int initial) {
        if (guiSupported) {
            String s = (String)JOptionPane.showInputDialog(null, message, title, 3, null, null, initial);
            return Integer.decode(s);
        }
        return null;
    }

    public static String inputStringValue(String message) {
        return StaticDialogs.inputStringValue(message, INPUT_DIALOG_MSG, "");
    }

    public static String inputStringValue(String message, String title, String initial) {
        if (guiSupported) {
            return (String)JOptionPane.showInputDialog(null, message, title, 3, null, null, initial);
        }
        return null;
    }

    public static Double inputDoubleValue(String message) {
        return StaticDialogs.inputDoubleValue(message, INPUT_DIALOG_MSG, 0.0);
    }

    public static Double inputDoubleValue(String message, String title, double initial) {
        if (guiSupported) {
            String s = (String)JOptionPane.showInputDialog(null, message, title, 3, null, null, initial);
            return Double.parseDouble(s);
        }
        return null;
    }

    public static int confirmMessage(String message) {
        return StaticDialogs.confirmMessage(message, "Confirmation");
    }

    public static int confirmMessage(String message, String title) {
        if (guiSupported) {
            return JOptionPane.showConfirmDialog(null, message, title, 1);
        }
        return 2;
    }
}

