/*
 * Decompiled with CFR 0.152.
 */
package emulib.runtime;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class UniversalFileFilter
extends FileFilter {
    private final Set<String> extensions = new LinkedHashSet<String>();
    private String description;

    public void addExtension(String extension) {
        String tmp = extension;
        while (tmp.startsWith(".")) {
            tmp = tmp.substring(1);
        }
        this.extensions.add(tmp);
    }

    public String getFirstExtension() {
        if (!this.extensions.isEmpty()) {
            return this.extensions.iterator().next();
        }
        return null;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String ext = UniversalFileFilter.getExtension(f);
        return ext != null ? this.extensions.stream().anyMatch(extension -> extension.equals(ext) || extension.equals("*")) : this.extensions.stream().anyMatch(extension -> extension.equals("*"));
    }

    public static String getExtension(File file) {
        String extension = null;
        String s = file.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            extension = s.substring(i + 1).toLowerCase();
        }
        return extension;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getExtensionsCount() {
        return this.extensions.size();
    }
}

